/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web;

import com.google.common.base.Preconditions;
import com.google.zxing.web.DoSTracker;
import java.io.IOException;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class DoSFilter
implements Filter {
    private Timer timer;
    private DoSTracker sourceAddrTracker;

    public void init(FilterConfig filterConfig) {
        int maxAccessPerTime = Integer.parseInt(filterConfig.getInitParameter("maxAccessPerTime"));
        Preconditions.checkArgument((maxAccessPerTime > 0 ? 1 : 0) != 0);
        int accessTimeSec = Integer.parseInt(filterConfig.getInitParameter("accessTimeSec"));
        Preconditions.checkArgument((accessTimeSec > 0 ? 1 : 0) != 0);
        long accessTimeMS = TimeUnit.MILLISECONDS.convert(accessTimeSec, TimeUnit.SECONDS);
        int maxEntries = Integer.parseInt(filterConfig.getInitParameter("maxEntries"));
        Preconditions.checkArgument((maxEntries > 0 ? 1 : 0) != 0);
        String name = this.getClass().getSimpleName();
        this.timer = new Timer(name);
        this.sourceAddrTracker = new DoSTracker(this.timer, name, maxAccessPerTime, accessTimeMS, maxEntries);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isBanned((HttpServletRequest)request)) {
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            servletResponse.setStatus(403);
            servletResponse.getWriter().write("Forbidden");
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isBanned(HttpServletRequest request) {
        String remoteHost = request.getHeader("x-forwarded-for");
        if (remoteHost != null) {
            int comma = remoteHost.indexOf(44);
            if (comma >= 0) {
                remoteHost = remoteHost.substring(0, comma);
            }
            remoteHost = remoteHost.trim();
        }
        return (remoteHost != null && this.sourceAddrTracker.isBanned(remoteHost)) | this.sourceAddrTracker.isBanned(request.getRemoteAddr());
    }

    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

