/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.web;

import com.google.common.io.Resources;
import com.google.common.net.MediaType;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.ImageReader;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import com.google.zxing.web.DoSTracker;
import com.google.zxing.web.ServletContextLogHandler;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;

/*
 * Exception performing whole class analysis ignored.
 */
@MultipartConfig(maxFileSize=0x4000000L, maxRequestSize=0x4000000L, fileSizeThreshold=0x800000, location="/tmp")
@WebServlet(value={"/w/decode"}, loadOnStartup=1, initParams={@WebInitParam(name="maxAccessPerTime", value="120"), @WebInitParam(name="accessTimeSec", value="120"), @WebInitParam(name="maxEntries", value="10000")})
public final class DecodeServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(DecodeServlet.class.getName());
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final long MAX_IMAGE_SIZE = 0x4000000L;
    private static final int MAX_PIXELS = 0x2000000;
    private static final Map<DecodeHintType, Object> HINTS = new EnumMap(DecodeHintType.class);
    private static final Map<DecodeHintType, Object> HINTS_PURE;
    private Collection<String> blockedURLSubstrings;
    private Timer timer;
    private DoSTracker destHostTracker;

    public void init(ServletConfig servletConfig) throws ServletException {
        Logger logger = Logger.getLogger("com.google.zxing");
        ServletContext context = servletConfig.getServletContext();
        logger.addHandler((Handler)new ServletContextLogHandler(context));
        URL blockURL = context.getClassLoader().getResource("/private/uri-block-substrings.txt");
        if (blockURL == null) {
            this.blockedURLSubstrings = Collections.emptyList();
        } else {
            try {
                this.blockedURLSubstrings = Resources.readLines((URL)blockURL, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioe) {
                throw new ServletException((Throwable)ioe);
            }
            log.info("Blocking URIs containing: " + this.blockedURLSubstrings);
        }
        int maxAccessPerTime = Integer.parseInt(servletConfig.getInitParameter("maxAccessPerTime"));
        int accessTimeSec = Integer.parseInt(servletConfig.getInitParameter("accessTimeSec"));
        long accessTimeMS = TimeUnit.MILLISECONDS.convert(accessTimeSec, TimeUnit.SECONDS);
        int maxEntries = Integer.parseInt(servletConfig.getInitParameter("maxEntries"));
        String name = this.getClass().getSimpleName();
        this.timer = new Timer(name);
        this.destHostTracker = new DoSTracker(this.timer, name, maxAccessPerTime, accessTimeMS, maxEntries, null);
    }

    public void destroy() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpURLConnection connection;
        URL imageURL;
        URI imageURI;
        String imageURIString = request.getParameter("u");
        if (imageURIString == null || imageURIString.isEmpty()) {
            log.info("URI was empty");
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        imageURIString = WHITESPACE.matcher(imageURIString).replaceAll("");
        if (!this.blockedURLSubstrings.isEmpty()) {
            for (CharSequence substring : this.blockedURLSubstrings) {
                if (!imageURIString.contains(substring)) continue;
                log.info("Disallowed URI " + imageURIString);
                DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
                return;
            }
        }
        try {
            imageURI = new URI(imageURIString);
            if (imageURI.getScheme() == null) {
                imageURI = new URI("http://" + imageURIString);
            }
        }
        catch (URISyntaxException e) {
            log.info("Error " + e + " while parsing URI: " + imageURIString);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        if ("data".equals(imageURI.getScheme())) {
            BufferedImage image;
            try {
                image = ImageReader.readDataURIImage((URI)imageURI);
            }
            catch (Exception e) {
                log.info("Error " + e + " while reading data URI: " + imageURIString);
                DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
                return;
            }
            if (image == null) {
                log.info("Couldn't read data URI: " + imageURIString);
                DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
                return;
            }
            try {
                DecodeServlet.processImage((BufferedImage)image, (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            finally {
                image.flush();
            }
        }
        if (this.destHostTracker.isBanned(imageURI.getHost())) {
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        try {
            imageURL = imageURI.toURL();
        }
        catch (MalformedURLException ignored) {
            log.info("URI is not a URL: " + imageURIString);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        String protocol = imageURL.getProtocol();
        if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            log.info("URL protocol was not valid: " + imageURIString);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        try {
            connection = (HttpURLConnection)imageURL.openConnection();
        }
        catch (IllegalArgumentException ignored) {
            log.info("URL could not be opened: " + imageURIString);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        connection.setAllowUserInteraction(false);
        connection.setInstanceFollowRedirects(true);
        connection.setReadTimeout(5000);
        connection.setConnectTimeout(5000);
        connection.setRequestProperty("User-Agent", "zxing.org");
        connection.setRequestProperty("Connection", "close");
        try {
            connection.connect();
        }
        catch (Exception e) {
            log.info("Error " + e + " connecting to " + imageURIString);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        try (InputStream is = connection.getInputStream();){
            if (connection.getResponseCode() != 200) {
                log.info("Unsuccessful return code " + connection.getResponseCode() + " from " + imageURIString);
                DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
                return;
            }
            if ((long)connection.getHeaderFieldInt("Content-Length", 0) > 0x4000000L) {
                log.info("Too large: " + imageURIString);
                DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
                return;
            }
            String contentType = connection.getContentType();
            if (contentType != null && !contentType.startsWith("image/")) {
                log.info("Wrong content type " + contentType + ": " + imageURIString);
                DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
                return;
            }
            log.info("Decoding " + imageURIString);
            DecodeServlet.processStream((InputStream)is, (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        catch (IOException ioe) {
            log.info("Error " + ioe + " processing " + imageURIString);
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badurl");
            return;
        }
        finally {
            connection.disconnect();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Collection parts;
        try {
            parts = request.getParts();
        }
        catch (Exception e) {
            log.info(e.toString());
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
            return;
        }
        Part fileUploadPart = null;
        for (Part part : parts) {
            if (part.getHeader("Content-Disposition") == null) continue;
            fileUploadPart = part;
            break;
        }
        if (fileUploadPart == null) {
            log.info("File upload was not multipart");
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
        } else {
            log.info("Decoding uploaded file " + fileUploadPart.getSubmittedFileName());
            try (InputStream is = fileUploadPart.getInputStream();){
                DecodeServlet.processStream((InputStream)is, (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processStream(InputStream is, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        BufferedImage image;
        try {
            image = ImageIO.read(is);
        }
        catch (Exception e) {
            log.info(e.toString());
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
            return;
        }
        if (image == null) {
            DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
            return;
        }
        try {
            int height = image.getHeight();
            int width = image.getWidth();
            if (height <= 1 || width <= 1 || height * width > 0x2000000) {
                log.info("Dimensions out of bounds: " + width + 'x' + height);
                DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"badimage");
                return;
            }
            DecodeServlet.processImage((BufferedImage)image, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        finally {
            image.flush();
        }
    }

    private static void processImage(BufferedImage image, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean minimalOutput;
        ArrayList<Result> results;
        block35: {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
            results = new ArrayList<Result>(1);
            try {
                Result theResult;
                MultiFormatReader reader = new MultiFormatReader();
                ReaderException savedException = null;
                try {
                    GenericMultipleBarcodeReader multiReader = new GenericMultipleBarcodeReader((Reader)reader);
                    Result[] theResults = multiReader.decodeMultiple(bitmap, HINTS);
                    if (theResults != null) {
                        results.addAll(Arrays.asList(theResults));
                    }
                }
                catch (ReaderException re) {
                    savedException = re;
                }
                if (results.isEmpty()) {
                    try {
                        theResult = reader.decode(bitmap, HINTS_PURE);
                        if (theResult != null) {
                            results.add(theResult);
                        }
                    }
                    catch (ReaderException re) {
                        savedException = re;
                    }
                }
                if (results.isEmpty()) {
                    try {
                        theResult = reader.decode(bitmap, HINTS);
                        if (theResult != null) {
                            results.add(theResult);
                        }
                    }
                    catch (ReaderException re) {
                        savedException = re;
                    }
                }
                if (results.isEmpty()) {
                    try {
                        BinaryBitmap hybridBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                        Result theResult2 = reader.decode(hybridBitmap, HINTS);
                        if (theResult2 != null) {
                            results.add(theResult2);
                        }
                    }
                    catch (ReaderException re) {
                        savedException = re;
                    }
                }
                if (!results.isEmpty()) break block35;
                try {
                    throw savedException == null ? NotFoundException.getNotFoundInstance() : savedException;
                }
                catch (ChecksumException | FormatException e) {
                    DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"format");
                }
                catch (ReaderException e) {
                    DecodeServlet.errorResponse((HttpServletRequest)request, (HttpServletResponse)response, (String)"notfound");
                }
                return;
            }
            catch (RuntimeException re) {
                log.log(Level.WARNING, "Unexpected exception from library", re);
                throw new ServletException((Throwable)re);
            }
        }
        String fullParameter = request.getParameter("full");
        boolean bl = minimalOutput = fullParameter != null && !Boolean.parseBoolean(fullParameter);
        if (minimalOutput) {
            response.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), StandardCharsets.UTF_8);){
                for (Result result : results) {
                    out.write(result.getText());
                    ((Writer)out).write(10);
                }
            }
        } else {
            request.setAttribute("results", results);
            request.getRequestDispatcher("decoderesult.jspx").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static void errorResponse(HttpServletRequest request, HttpServletResponse response, String key) throws ServletException, IOException {
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        ResourceBundle bundle = ResourceBundle.getBundle("Strings", locale);
        String title = bundle.getString("response.error." + key + ".title");
        String text = bundle.getString("response.error." + key + ".text");
        request.setAttribute("title", (Object)title);
        request.setAttribute("text", (Object)text);
        RequestDispatcher dispatcher = request.getRequestDispatcher("response.jspx");
        if (dispatcher == null) {
            log.warning("Can't obtain RequestDispatcher");
        } else {
            response.setStatus(400);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    static {
        HINTS.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        HINTS.put(DecodeHintType.POSSIBLE_FORMATS, EnumSet.allOf(BarcodeFormat.class));
        HINTS_PURE = new EnumMap(HINTS);
        HINTS_PURE.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
    }
}

