<!-- Copyright © 2012, 2013 dr. ir. Jeroen M. Valk -->

<!-- This file is part of Badgerfish CPX. Badgerfish CPX is free software: 
	you can redistribute it and/or modify it under the terms of the GNU Lesser 
	General Public License as published by the Free Software Foundation, either 
	version 3 of the License, or (at your option) any later version. Badgerfish 
	CPX is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
	without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
	PURPOSE. See the GNU Lesser General Public License for more details. You 
	should have received a copy of the GNU Lesser General Public License along 
	with Badgerfish CPX. If not, see <http://www.gnu.org/licenses/>. -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="2.0" xmlns:mvn="http://maven.apache.org/POM/4.0.0">
	<xsl:output method="xml" indent="yes" />
	<xsl:output method="xml" indent="yes" name="xml" />
	<xsl:param name="usecmd" select="'no'" />
	<xsl:param name="target" select="'target'" />
	<xsl:template match="/">
		<xsl:variable name="npm"
			select="document(pom.xml)/project/properties/npm"></xsl:variable>
		<project name="project" default="default">
			<target name="default" description="description">
				<mkdir dir="target/downloads" />
				<xsl:for-each select="//npm">
					<xsl:variable name="filename"
						select="concat('file:///',$target,'/assembly/',@name,'.xml')" />
					<exec dir="target">
						<xsl:choose>
							<xsl:when test="$usecmd='yes'">
								<xsl:attribute name="executable">cmd</xsl:attribute>
								<arg value="/c" />
								<arg>
									<xsl:attribute name="value"><xsl:value-of
										select="document('../../pom.xml')/mvn:project/mvn:properties/mvn:npm" /></xsl:attribute>
								</arg>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="executable"><xsl:value-of
									select="document('../../pom.xml')/mvn:project/mvn:properties/mvn:npm" /></xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<arg value="install" />
						<arg>
							<xsl:attribute name="value"><xsl:value-of
								select="@name" /></xsl:attribute>
						</arg>
					</exec>
					<xsl:result-document href="{$filename}" format="xml">
						<assembly
							xmlns="http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.0"
							xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
							xsi:schemaLocation="http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.0 http://maven.apache.org/xsd/assembly-1.1.0.xsd">
							<id><xsl:value-of select="@name" /></id>
							<formats>
								<format>zip</format>
							</formats>
							<baseDirectory><xsl:value-of select="@name" /></baseDirectory>
							<fileSets>
								<fileSet>
									<directory>${project.build.directory}/node_modules/<xsl:value-of
										select="@name" /></directory>
									<outputDirectory>/</outputDirectory>
								</fileSet>
							</fileSets>
						</assembly>
					</xsl:result-document>
				</xsl:for-each>
				<xsl:for-each select="//zipfile">
					<xsl:variable name="filename"
						select="concat('file:///',$target,'/assembly/',@name,'.xml')" />
					<get skipexisting="true">
						<xsl:attribute name="src"><xsl:value-of
							select="@url" /></xsl:attribute>
						<xsl:attribute name="dest">target/downloads/<xsl:value-of
							select="@name" />.zip</xsl:attribute>
					</get>
					<unzip>
						<xsl:attribute name="src">target/downloads/<xsl:value-of
							select="@name" />.zip</xsl:attribute>
						<xsl:attribute name="dest">target/downloads/<xsl:value-of
							select="@name" /></xsl:attribute>
						<cutdirsmapper dirs="1" />
					</unzip>
					<xsl:result-document href="{$filename}" format="xml">
						<assembly
							xmlns="http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.0"
							xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
							xsi:schemaLocation="http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.0 http://maven.apache.org/xsd/assembly-1.1.0.xsd">
							<id><xsl:value-of select="@name" /></id>
							<formats>
								<format>zip</format>
							</formats>
							<baseDirectory><xsl:value-of select="@name" /></baseDirectory>
							<fileSets>
								<fileSet>
									<directory>${project.build.directory}/downloads/<xsl:value-of
										select="@name" /></directory>
									<outputDirectory>/</outputDirectory>
								</fileSet>
							</fileSets>
						</assembly>
					</xsl:result-document>
				</xsl:for-each>
				<xsl:for-each select="//files">
					<xsl:variable name="filename"
						select="concat('file:///',$target,'/assembly/',@name,'.xml')" />
					<mkdir>
						<xsl:attribute name="dir">target/downloads/<xsl:value-of
							select="@name" /></xsl:attribute>
					</mkdir>
					<xsl:for-each select="file">
						<get skipexisting="true">
							<xsl:attribute name="src"><xsl:value-of
								select="@url" /></xsl:attribute>
							<xsl:attribute name="dest">target/downloads/<xsl:value-of
								select="../@name" />/<xsl:value-of select="@name" /></xsl:attribute>
						</get>
					</xsl:for-each>
					<xsl:result-document href="{$filename}" format="xml">
						<assembly
							xmlns="http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.0"
							xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
							xsi:schemaLocation="http://maven.apache.org/plugins/maven-assembly-plugin/assembly/1.1.0 http://maven.apache.org/xsd/assembly-1.1.0.xsd">
							<id><xsl:value-of select="@name" /></id>
							<formats>
								<format>zip</format>
							</formats>
							<baseDirectory><xsl:value-of select="@name" /></baseDirectory>
							<fileSets>
								<fileSet>
									<directory>${project.build.directory}/downloads/<xsl:value-of
										select="@name" /></directory>
									<outputDirectory>/</outputDirectory>
								</fileSet>
							</fileSets>
						</assembly>
					</xsl:result-document>
				</xsl:for-each>
			</target>
		</project>
	</xsl:template>
</xsl:stylesheet>