/**
 * Copyright © 2012, 2013 dr. ir. Jeroen M. Valk
 * 
 * This file is part of Badgerfish CPX. Badgerfish CPX is free software:
 * you can redistribute it and/or modify it under the terms of the GNU Lesser
 * General Public License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version. Badgerfish
 * CPX is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more details. You
 * should have received a copy of the GNU Lesser General Public License along
 * with Badgerfish CPX. If not, see <http://www.gnu.org/licenses/>.
 */

package com.googlecode.aaw.mojo;

import org.apache.maven.plugin.logging.Log;

import com.googlecode.aaw.arche.AbstractLogger;

public final class Logger extends AbstractLogger implements org.slf4j.Logger {
	private static final long serialVersionUID = 599906589012570103L;
	static private Log log = null;
		
	static public void setLog(Log newLog) {
		log = newLog;
	}
	
	@Override
	protected void log_trace(String msg, Throwable t) {
		this.error("MOJO logger has no TRACE level");
	}

	@Override
	protected void log_debug(String msg, Throwable t) {
		if (t == null) {
			log.debug(msg);
		} else {
			log.debug(msg, t);
		}
	}

	@Override
	protected void log_info(String msg, Throwable t) {
		if (t == null) {
			log.info(msg);
		} else {
			log.info(msg, t);
		}
	}

	@Override
	protected void log_warn(String msg, Throwable t) {
		if (t == null) {
			log.warn(msg);
		} else {
			log.warn(msg, t);
		}
	}

	@Override
	protected void log_error(String msg, Throwable t) {
		if (t == null) {
			log.error(msg);
		} else {
			log.error(msg, t);
		}
	}

}
