/**
 * Copyright © 2012, 2013 dr. ir. Jeroen M. Valk
 * 
 * This file is part of Badgerfish CPX. Badgerfish CPX is free software:
 * you can redistribute it and/or modify it under the terms of the GNU Lesser
 * General Public License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version. Badgerfish
 * CPX is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more details. You
 * should have received a copy of the GNU Lesser General Public License along
 * with Badgerfish CPX. If not, see <http://www.gnu.org/licenses/>.
 */

package com.googlecode.aaw.mojo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/**
 * Install an XML file in the Badgerfish service.
 * 
 * @goal install
 * 
 * @phase integration-test
 */
public class Reset extends AbstractMojo {

	/**
	 * File to install.
	 * 
	 * @parameter expression="${basedir}/.."
	 * @required
	 */
	private File workspace;

	@Override
	public void execute() throws MojoExecutionException, MojoFailureException {
		HttpURLConnection connection = null;
		try {
			connection = (HttpURLConnection) new URL(
					"http://localhost:8080/reset")
					.openConnection();
		} catch (MalformedURLException e) {
			throw new MojoExecutionException(e.getMessage(), e);
		} catch (IOException e) {
			throw new MojoExecutionException(
					"Connection to badgerfish service failed", e);
		}
		try {
			connection.setRequestMethod("POST");
		} catch (ProtocolException e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}
		connection.setRequestProperty("Content-Type", "text/xml");
		connection.setDoOutput(true);

		Writer writer;
		try {
			writer = new PrintWriter(connection.getOutputStream());
		} catch (IOException e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}
		try {
			writer.write("<projects>");
		} catch (IOException e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}
		String[] file = workspace.list();
		for (int i =0; i<file.length; ++i) {
			File project = new File(workspace, file[i]);
			if (project.isDirectory()) {
				File pom = new File(workspace, "pom.xml");
				if (pom.isFile()) {
				try {
					writer.write("<pom url='"+pom.toURI().toURL().toExternalForm()+"' />");
				} catch (MalformedURLException e) {
					throw new MojoExecutionException(e.getMessage(), e);
				} catch (IOException e) {
					throw new MojoExecutionException(e.getMessage(), e);
				}
				}
			}
		}
		try {
			writer.write("</projects>");
		} catch (IOException e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}
		try {
			writer.close();
		} catch (IOException e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}

		InputStream is;
		try {
			is = connection.getInputStream();
		} catch (IOException e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}
		BufferedReader rd = new BufferedReader(new InputStreamReader(is));
		String line;
		try {
			while ((line = rd.readLine()) != null) {
				getLog().info(line);
			}
		} catch (IOException e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}
		try {
			rd.close();
		} catch (IOException e) {
			throw new MojoExecutionException(e.getMessage(), e);
		}
	}

}
