/**
 * Copyright © 2012, 2013 dr. ir. Jeroen M. Valk
 * 
 * This file is part of Badgerfish CPX. Badgerfish CPX is free software:
 * you can redistribute it and/or modify it under the terms of the GNU Lesser
 * General Public License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version. Badgerfish
 * CPX is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more details. You
 * should have received a copy of the GNU Lesser General Public License along
 * with Badgerfish CPX. If not, see <http://www.gnu.org/licenses/>.
 */

package com.googlecode.aaw.mojo;
/*
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.xml.sax.InputSource;

import com.googlecode.aaw.arche.Arche;
import com.googlecode.aaw.badgerfish.Badgerfish;
import com.googlecode.aaw.badgerfish.NodeJS;

/**
 * Compile Javascript written in the Badgerfish framework.
 * 
 * @goal test
 * 
 * @phase test
 */
public class Test extends AbstractMojo {

	/**
	 * Target directory where the compiled Javascript is located.
	 * 
	 * @parameter expression="${target}"
	 * @required
	 */
	private File targetPath;

	public void execute() throws MojoFailureException, MojoExecutionException {
		Arche arche = Arche.getArche(Test.class, new LoggerFactory(getLog()));
		Logger logger = (Logger) arche.getInstance();
		InputSource input = new InputSource();
		try {
			input.setByteStream(new FileInputStream(new File(targetPath,
					"/classes.xml")));
		} catch (FileNotFoundException e) {
			logger.info("nothing to test");
			return;
		}
		Badgerfish badgerfish = new Badgerfish(input, targetPath);
		badgerfish.startDocument();
		badgerfish.startElement("badgerfish");
		badgerfish.startElement("config").setAttribute("mainclass",
				"nl.agentsatwork.badgerfish.Tester");
		badgerfish.endElement();
		badgerfish.endElement();
		badgerfish.endDocument();
		NodeJS node = new NodeJS(badgerfish, 0);
		int status = node.waitForExitValue();
		if (status != 0) {
			throw new MojoFailureException("NodeJS exited with status: "
					+ status);
		}
		if (logger.getErrorCount() > 0) {
			throw new MojoExecutionException(logger.getErrorCount()
					+ " ERRORS; " + logger.getWarnCount() + " WARNINGS");
		}
	}
}
