/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aaw.mojo;

import com.googlecode.aaw.arche.Arche;
import com.googlecode.aaw.badgerfish.Badgerfish;
import com.googlecode.aaw.badgerfish.NodeJS;
import com.googlecode.aaw.mojo.Logger;
import com.googlecode.aaw.mojo.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.slf4j.ILoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class Compile
extends AbstractMojo {
    private File sourceMain;
    private File sourceTest;
    private File outputDirectory;
    private File dependencyDirectory;
    private String compilerArtifactId;
    private String compilerVersion;
    private String bootstrap;

    public void execute() throws MojoFailureException, MojoExecutionException {
        Arche arche = Arche.getArche(Compile.class, (ILoggerFactory)new LoggerFactory(this.getLog()));
        Logger logger = (Logger)((Object)arche.getInstance());
        if (!this.sourceMain.isDirectory() && !this.sourceTest.isDirectory()) {
            logger.info("nothing to compile");
            return;
        }
        Badgerfish badgerfish = null;
        if (this.bootstrap != null) {
            badgerfish = new Badgerfish(null, this.dependencyDirectory);
            badgerfish.startDocument();
            badgerfish.startElement("badgerfish");
            badgerfish.startElement("config");
            badgerfish.element("outputDirectory", this.outputDirectory.getPath());
            badgerfish.endElement();
            String path = this.bootstrap.replaceAll("\\.", "/");
            File script = new File(this.sourceMain, path + ".js");
            try {
                badgerfish.element("script", (Reader)new FileReader(script));
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage());
            }
        } else {
            InputSource input = new InputSource();
            try {
                input.setByteStream(new FileInputStream(new File(this.dependencyDirectory, this.compilerArtifactId + "-" + this.compilerVersion + "/classes.xml")));
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage(), e);
            }
            badgerfish = new Badgerfish(input, this.dependencyDirectory);
            badgerfish.startDocument();
            badgerfish.startElement("badgerfish");
            badgerfish.startElement("config");
            badgerfish.element("sourceMain", this.sourceMain.getPath());
            badgerfish.element("sourceTest", this.sourceTest.getPath());
            badgerfish.element("outputDirectory", this.outputDirectory.getPath());
            badgerfish.endElement();
        }
        badgerfish.endElement();
        badgerfish.endDocument();
        if (!this.outputDirectory.isDirectory()) {
            this.outputDirectory.mkdirs();
        }
        Element config = badgerfish.selectElement(null, "badgerfish/config");
        logger.info("Main source directory: " + badgerfish.selectText(config, "sourceMain"));
        logger.info("Test source directory: " + badgerfish.selectText(config, "sourceTest"));
        NodeJS node = new NodeJS(badgerfish, 0);
        int status = node.waitForExitValue();
        logger.info("Compiling Javascript sources to: " + badgerfish.toFile().getAbsolutePath());
        if (status != 0) {
            throw new MojoFailureException("NodeJS exited with status: " + status);
        }
        if (logger.getErrorCount() > 0) {
            throw new MojoExecutionException(logger.getErrorCount() + " ERRORS; " + logger.getWarnCount() + " WARNINGS");
        }
    }
}

