/**
 * Copyright © 2012, 2013 dr. ir. Jeroen M. Valk
 * 
 * This file is part of Badgerfish CPX. Badgerfish CPX is free software:
 * you can redistribute it and/or modify it under the terms of the GNU Lesser
 * General Public License as published by the Free Software Foundation, either
 * version 3 of the License, or (at your option) any later version. Badgerfish
 * CPX is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more details. You
 * should have received a copy of the GNU Lesser General Public License along
 * with Badgerfish CPX. If not, see <http://www.gnu.org/licenses/>.
 */

package com.googlecode.aaw.service;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.SAXParser;

import org.slf4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.googlecode.aaw.arche.Arche;
import com.googlecode.aaw.badgerfish.Connect;
import com.googlecode.aaw.init.Reset;

public class Servlet extends HttpServlet {
	private static final Arche arche = Arche.getArche(Servlet.class,
			new LoggerFactory());
	private static final long serialVersionUID = 5498438586082902958L;
	private static final Logger logger = (Logger) arche.getInstance();
	private static final SAXParser parser = (SAXParser) arche.getInstance();
	private static final Reset reset = new Reset();

	public void init(ServletConfig config) throws ServletException {
		logger.info("Initializing...");
		try {
			parser.parse(
					new InputSource(new StringReader("<reset><workspace>"
							+ System.getProperty("workspace")
							+ "</workspace></reset>")), reset);
		} catch (SAXException e) {
			throw new ServletException(e);
		} catch (IOException e) {
			throw new ServletException(e);
		}
	}

	public void service(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		String[] path = request.getServletPath().split("/");
		logger.info(request.getServletPath());
		if (!path[0].equals("")) {
			throw new ServletException("servlet path must be absolute");
		}
		if (path[1].equals("reset")) {
			if (request.getContentType().equals("text/xml")) {
				try {
					parser.parse(new InputSource(request.getInputStream()),
							reset);
				} catch (SAXException e) {
					throw new ServletException(e);
				}
			}
		} else {
			File workspace = reset.getWorkspace();
			if (workspace.isDirectory()) {
				File project = new File(workspace, path[1]);
				if (project.isDirectory()) {
					File pom = new File(project, "pom.xml");
					if (pom.isFile()) {
						if (path[2].equals("site")) {
							URL url = null;
							String suffix;
							if (path.length > 4) {
								StringBuilder builder = new StringBuilder();
								builder.append(path[4]);
								for (int i = 5; i < path.length; ++i) {
									builder.append('/');
									builder.append(path[i]);
								}
								suffix = builder.toString();
								if (suffix.equals("")) {
									suffix = "index.html";
								}
							} else {
								suffix = "index.html";
							}
							if (suffix.endsWith(".html")) {
								response.setContentType("text/html");
							} else if (suffix.endsWith(".js")) {
								response.setContentType("text/javascript");
							} else if (suffix.endsWith(".png")) {
								response.setContentType("image/png");
							}
							if (path[3].equals("slides") && suffix != null) {
								url = new URL(project.toURI().toURL()
										.toExternalForm()
										+ "/target/dependency/" + suffix);
							}
							if (path[3].equals("browser") && suffix != null) {
								url = new URL(project.toURI().toURL()
										.toExternalForm()
										+ "/target/dependency/docbook/slides/browser/" + suffix);									
							}
							if (path[3].equals("graphics") && suffix != null) {
								url = new URL(project.toURI().toURL()
										.toExternalForm()
										+ "/target/dependency/docbook/slides/graphics/" + suffix);									
							}
							if (url == null) {
								response.sendError(HttpServletResponse.SC_NOT_FOUND);
							} else {
								Connect connect = new Connect(url
										.openConnection().getInputStream(),
										response.getOutputStream());
								connect.run();
								connect.done();
							}
						}
					} else {
						response.sendError(HttpServletResponse.SC_NOT_FOUND,
								"POM '" + workspace.getAbsolutePath() + "/"
										+ path[1] + "/pom.xml" + "' not found");

					}
				} else {
					response.sendError(
							HttpServletResponse.SC_NOT_FOUND,
							"project '" + path[1]
									+ "' not found in workspace '"
									+ workspace.getAbsolutePath() + "'");
				}
			} else {
				response.sendError(HttpServletResponse.SC_NOT_FOUND,
						"workspace '" + workspace.getAbsolutePath()
								+ "' not found");
			}
		}
	}

}
