/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aaw.service;

import com.googlecode.aaw.arche.Arche;
import com.googlecode.aaw.badgerfish.Connect;
import com.googlecode.aaw.init.Reset;
import com.googlecode.aaw.service.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.SAXParser;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Servlet
extends HttpServlet {
    private static final Arche arche = Arche.getArche(Servlet.class, (ILoggerFactory)new LoggerFactory());
    private static final long serialVersionUID = 5498438586082902958L;
    private static final Logger logger = (Logger)arche.getInstance();
    private static final SAXParser parser = (SAXParser)arche.getInstance();
    private static final Reset reset = new Reset();

    public void init(ServletConfig config) throws ServletException {
        logger.info("Initializing...");
        try {
            parser.parse(new InputSource(new StringReader("<reset><workspace>" + System.getProperty("workspace") + "</workspace></reset>")), (DefaultHandler)reset);
        }
        catch (SAXException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String[] path = request.getServletPath().split("/");
        logger.info(request.getServletPath());
        if (!path[0].equals("")) {
            throw new ServletException("servlet path must be absolute");
        }
        if (path[1].equals("reset")) {
            if (request.getContentType().equals("text/xml")) {
                try {
                    parser.parse(new InputSource((InputStream)request.getInputStream()), (DefaultHandler)reset);
                }
                catch (SAXException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        } else {
            File workspace = reset.getWorkspace();
            if (workspace.isDirectory()) {
                File project = new File(workspace, path[1]);
                if (project.isDirectory()) {
                    File pom = new File(project, "pom.xml");
                    if (pom.isFile()) {
                        if (path[2].equals("site")) {
                            String suffix;
                            URL url = null;
                            if (path.length > 4) {
                                StringBuilder builder = new StringBuilder();
                                builder.append(path[4]);
                                for (int i = 5; i < path.length; ++i) {
                                    builder.append('/');
                                    builder.append(path[i]);
                                }
                                suffix = builder.toString();
                                if (suffix.equals("")) {
                                    suffix = "index.html";
                                }
                            } else {
                                suffix = "index.html";
                            }
                            if (suffix.endsWith(".html")) {
                                response.setContentType("text/html");
                            } else if (suffix.endsWith(".js")) {
                                response.setContentType("text/javascript");
                            } else if (suffix.endsWith(".png")) {
                                response.setContentType("image/png");
                            }
                            if (path[3].equals("slides") && suffix != null) {
                                url = new URL(project.toURI().toURL().toExternalForm() + "/target/dependency/" + suffix);
                            }
                            if (path[3].equals("browser") && suffix != null) {
                                url = new URL(project.toURI().toURL().toExternalForm() + "/target/dependency/docbook/slides/browser/" + suffix);
                            }
                            if (path[3].equals("graphics") && suffix != null) {
                                url = new URL(project.toURI().toURL().toExternalForm() + "/target/dependency/docbook/slides/graphics/" + suffix);
                            }
                            if (url == null) {
                                response.sendError(404);
                            } else {
                                Connect connect = new Connect(url.openConnection().getInputStream(), (OutputStream)response.getOutputStream());
                                connect.run();
                                connect.done();
                            }
                        }
                    } else {
                        response.sendError(404, "POM '" + workspace.getAbsolutePath() + "/" + path[1] + "/pom.xml" + "' not found");
                    }
                } else {
                    response.sendError(404, "project '" + path[1] + "' not found in workspace '" + workspace.getAbsolutePath() + "'");
                }
            } else {
                response.sendError(404, "workspace '" + workspace.getAbsolutePath() + "' not found");
            }
        }
    }
}

