/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.asm;

import jw.asmsupport.asm.StackLocalMethodVisitor;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.definition.method.Method;
import jw.asmsupport.definition.variable.LocalVariable;
import jw.asmsupport.operators.util.OperatorFactory;
import jw.asmsupport.utils.LocalVariables;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class InstructionHelper {
    private static Log log = LogFactory.getLog(InstructionHelper.class);
    private static final String CLDESC = "Ljava/lang/Class;";
    private boolean castAndbox = true;
    private StackLocalMethodVisitor mv;
    private Method method;
    protected LocalVariables locals;
    public static final int EQ = 153;
    public static final int NE = 154;
    public static final int LT = 155;
    public static final int GE = 156;
    public static final int GT = 157;
    public static final int LE = 158;

    public InstructionHelper(MethodVisitor mv, Method method) {
        this.mv = new StackLocalMethodVisitor(mv, method.getStack());
        this.method = method;
        this.locals = this.method.getLocals();
    }

    public Method getMethod() {
        return this.method;
    }

    public StackLocalMethodVisitor getMv() {
        return this.mv;
    }

    public void setMv(StackLocalMethodVisitor mv) {
        this.mv = mv;
    }

    private void pushInt(int value) {
        if (value >= -1 && value <= 5) {
            this.getMv().visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            this.getMv().visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            this.getMv().visitIntInsn(17, value);
        } else {
            this.getMv().visitLdcInsn(new Integer(value));
        }
    }

    public void push(boolean value) {
        this.pushInt(value ? 1 : 0);
    }

    public void push(int value) {
        this.pushInt(value);
    }

    public void push(byte value) {
        this.pushInt(value);
    }

    public void push(short value) {
        this.pushInt(value);
    }

    public void push(char value) {
        this.pushInt(value);
    }

    public void push(long value) {
        if (value == 0L || value == 1L) {
            this.getMv().visitInsn(9 + (int)value);
        } else {
            this.getMv().visitLdcInsn(new Long(value));
        }
    }

    public void push(float value) {
        int bits = Float.floatToIntBits(value);
        if ((long)bits == 0L || bits == 1065353216 || bits == 0x40000000) {
            this.getMv().visitInsn(11 + (int)value);
        } else {
            this.getMv().visitLdcInsn(new Float(value));
        }
    }

    public void push(double value) {
        long bits = Double.doubleToLongBits(value);
        if (bits == 0L || bits == 0x3FF0000000000000L) {
            this.getMv().visitInsn(14 + (int)value);
        } else {
            this.getMv().visitLdcInsn(new Double(value));
        }
    }

    public void push(String value) {
        if (value == null) {
            this.push(AClass.STRING_ACLASS.getType());
        } else {
            this.getMv().visitLdcInsn(value);
        }
    }

    public void push(Type type) {
        this.getMv().setNextPushTypes(type);
        this.getMv().visitInsn(1);
    }

    public void pushClass(Type value) {
        if (value == null) {
            this.mv.visitInsn(1);
        } else {
            switch (value.getSort()) {
                case 1: {
                    this.mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", CLDESC);
                    break;
                }
                case 2: {
                    this.mv.visitFieldInsn(178, "java/lang/Character", "TYPE", CLDESC);
                    break;
                }
                case 3: {
                    this.mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", CLDESC);
                    break;
                }
                case 4: {
                    this.mv.visitFieldInsn(178, "java/lang/Short", "TYPE", CLDESC);
                    break;
                }
                case 5: {
                    this.mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", CLDESC);
                    break;
                }
                case 6: {
                    this.mv.visitFieldInsn(178, "java/lang/Float", "TYPE", CLDESC);
                    break;
                }
                case 7: {
                    this.mv.visitFieldInsn(178, "java/lang/Long", "TYPE", CLDESC);
                    break;
                }
                case 8: {
                    this.mv.visitFieldInsn(178, "java/lang/Double", "TYPE", CLDESC);
                    break;
                }
                default: {
                    this.mv.visitLdcInsn(value);
                }
            }
        }
    }

    public void cast(Type from, Type to) {
        if (!this.castAndbox) {
            return;
        }
        if (from != to) {
            if (from == Type.BOOLEAN_TYPE || to == Type.BOOLEAN_TYPE) {
                throw new IllegalArgumentException("canot cast from boolean or to boolean type!");
            }
            if (from == Type.DOUBLE_TYPE) {
                if (to == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(144);
                } else if (to == Type.LONG_TYPE) {
                    this.mv.visitInsn(143);
                } else {
                    this.mv.visitInsn(142);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (from == Type.FLOAT_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(141);
                } else if (to == Type.LONG_TYPE) {
                    this.mv.visitInsn(140);
                } else {
                    this.mv.visitInsn(139);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (from == Type.LONG_TYPE) {
                if (to == Type.DOUBLE_TYPE) {
                    this.mv.visitInsn(138);
                } else if (to == Type.FLOAT_TYPE) {
                    this.mv.visitInsn(137);
                } else {
                    this.mv.visitInsn(136);
                    this.cast(Type.INT_TYPE, to);
                }
            } else if (to == Type.BYTE_TYPE) {
                this.mv.visitInsn(145);
            } else if (to == Type.CHAR_TYPE) {
                this.mv.visitInsn(146);
            } else if (to == Type.DOUBLE_TYPE) {
                this.mv.visitInsn(135);
            } else if (to == Type.FLOAT_TYPE) {
                this.mv.visitInsn(134);
            } else if (to == Type.LONG_TYPE) {
                this.mv.visitInsn(133);
            } else if (to == Type.SHORT_TYPE) {
                this.mv.visitInsn(147);
            }
        }
    }

    public void checkCast(Type type) {
        if (!type.equals((Object)AClass.OBJECT_ACLASS.getType())) {
            this.typeInsn(192, type);
        }
    }

    public static Type getBoxedType(Type type) {
        switch (type.getSort()) {
            case 3: {
                return AClass.BYTE_WRAP_ACLASS.getType();
            }
            case 1: {
                return AClass.BOOLEAN_WRAP_ACLASS.getType();
            }
            case 4: {
                return AClass.SHORT_WRAP_ACLASS.getType();
            }
            case 2: {
                return AClass.CHARACTER_WRAP_ACLASS.getType();
            }
            case 5: {
                return AClass.INTEGER_WRAP_ACLASS.getType();
            }
            case 6: {
                return AClass.FLOAT_WRAP_ACLASS.getType();
            }
            case 7: {
                return AClass.LONG_WRAP_ACLASS.getType();
            }
            case 8: {
                return AClass.DOUBLE_WRAP_ACLASS.getType();
            }
        }
        return type;
    }

    public static Type getUnBoxedType(Type type) {
        if (type.equals((Object)AClass.BYTE_WRAP_ACLASS.getType())) {
            return Type.BYTE_TYPE;
        }
        if (type.equals((Object)AClass.BOOLEAN_WRAP_ACLASS.getType())) {
            return Type.BOOLEAN_TYPE;
        }
        if (type.equals((Object)AClass.SHORT_WRAP_ACLASS.getType())) {
            return Type.SHORT_TYPE;
        }
        if (type.equals((Object)AClass.CHARACTER_WRAP_ACLASS.getType())) {
            return Type.CHAR_TYPE;
        }
        if (type.equals((Object)AClass.INTEGER_WRAP_ACLASS.getType())) {
            return Type.INT_TYPE;
        }
        if (type.equals((Object)AClass.FLOAT_WRAP_ACLASS.getType())) {
            return Type.FLOAT_TYPE;
        }
        if (type.equals((Object)AClass.LONG_WRAP_ACLASS.getType())) {
            return Type.LONG_TYPE;
        }
        if (type.equals((Object)AClass.DOUBLE_WRAP_ACLASS.getType())) {
            return Type.DOUBLE_TYPE;
        }
        return type;
    }

    public void box(Type type) {
        if (!this.castAndbox) {
            return;
        }
        if (type.getSort() == 10 || type.getSort() == 9 || type.getSort() == 0) {
            return;
        }
        if (type == Type.VOID_TYPE) {
            this.push((String)null);
        } else {
            Type boxed = InstructionHelper.getBoxedType(type);
            this.newInstance(boxed);
            if (type.getSize() == 2) {
                this.dupX2();
                this.dupX2();
                this.pop();
            } else {
                this.dupX1();
                this.swap();
            }
            this.invokeConstructor(boxed, new Type[]{type});
        }
    }

    public void valueOf(Type type) {
        if (type.getSort() == 10 || type.getSort() == 9) {
            return;
        }
        if (type == Type.VOID_TYPE) {
            this.push((String)null);
        } else {
            Type boxed = InstructionHelper.getBoxedType(type);
            this.invokeStatic(boxed, "valueOf", boxed, new Type[]{type});
        }
    }

    public void unbox(Type type) {
        if (!this.castAndbox) {
            return;
        }
        if (type.getSort() < 10) {
            return;
        }
        Type primitiveType = InstructionHelper.getUnBoxedType(type);
        String methodName = null;
        switch (primitiveType.getSort()) {
            case 0: {
                return;
            }
            case 2: {
                methodName = "cahrValue";
                break;
            }
            case 1: {
                methodName = "booleanValue";
                break;
            }
            case 8: {
                methodName = "doubleValue";
                break;
            }
            case 6: {
                methodName = "floatValue";
                break;
            }
            case 7: {
                methodName = "longValue";
                break;
            }
            case 5: {
                methodName = "intValue";
                break;
            }
            case 4: {
                methodName = "shortValue";
                break;
            }
            case 3: {
                methodName = "byteValue";
            }
        }
        if (methodName != null) {
            this.invokeVirtual(type, methodName, primitiveType, new Type[0]);
        }
    }

    public void mark(Label label) {
        this.getMv().visitLabel(label);
    }

    public void nop() {
        this.getMv().visitInsn(0);
    }

    public void loadInsn(Type type, int index) {
        int opcode = type.getOpcode(21);
        if (opcode == 25) {
            this.getMv().setNextPushTypes(type);
        }
        this.getMv().visitVarInsn(opcode, index);
    }

    public void loadThis() {
        this.getMv().setNextPushTypes(this.method.getMethodEntity().getOwner().getType());
        this.getMv().visitVarInsn(25, 0);
    }

    public void storeInsn(LocalVariable var) {
        this.locals.setCursor(var.getScopeLogicVar());
        this.locals.printState();
        this.getMv().visitVarInsn(var.getVariableEntity().getDeclareClass().getType().getOpcode(54), var.getScopeLogicVar().getInitStartPos());
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void dup() {
        this.getMv().visitInsn(89);
    }

    public void dupX1() {
        this.mv.visitInsn(90);
    }

    public void dupX2() {
        this.mv.visitInsn(91);
    }

    private void typeInsn(int opcode, Type type) {
        this.getMv().visitTypeInsn(opcode, type.getInternalName());
    }

    public void newInstance(Type type) {
        this.typeInsn(187, type);
    }

    private void invokeInsn(int opcode, Type type, String name, Type returnType, Type[] arguTypes) {
        String owner = type.getSort() == 9 ? type.getDescriptor() : type.getInternalName();
        this.getMv().visitMethodInsn(opcode, owner, name, Type.getMethodDescriptor((Type)returnType, (Type[])arguTypes));
    }

    public void invokeVirtual(Type owner, String name, Type returnType, Type[] arguTypes) {
        this.invokeInsn(182, owner, name, returnType, arguTypes);
    }

    public void invokeConstructor(Type ownerType, Type[] argTypes) {
        this.invokeInsn(183, ownerType, "<init>", Type.VOID_TYPE, argTypes);
    }

    public void invokeSuperMethod(Type ownerType, String name, Type returnType, Type[] argTypes) {
        this.invokeInsn(183, ownerType, name, returnType, argTypes);
    }

    public void invokeStatic(Type owner, String name, Type returnType, Type[] arguTypes) {
        this.invokeInsn(184, owner, name, returnType, arguTypes);
    }

    public void invokeInterface(Type owner, String name, Type returnType, Type[] arguTypes) {
        this.invokeInsn(185, owner, name, returnType, arguTypes);
    }

    private void fieldInsn(int opcode, Type ownerType, String name, Type fieldType) {
        this.getMv().visitFieldInsn(opcode, ownerType.getInternalName(), name, fieldType.getDescriptor());
    }

    public void getStatic(Type owner, String name, Type type) {
        this.fieldInsn(178, owner, name, type);
    }

    public void putStatic(Type owner, String name, Type type) {
        this.fieldInsn(179, owner, name, type);
    }

    public void getField(Type owner, String name, Type type) {
        this.fieldInsn(180, owner, name, type);
    }

    public void putField(Type owner, String name, Type type) {
        this.fieldInsn(181, owner, name, type);
    }

    private void arithmetic(Type type, int opcode) {
        this.mv.visitInsn(opcode);
    }

    public void add(Type type) {
        this.arithmetic(type, type.getOpcode(96));
    }

    public void sub(Type type) {
        this.arithmetic(type, type.getOpcode(100));
    }

    public void mul(Type type) {
        this.arithmetic(type, type.getOpcode(104));
    }

    public void div(Type type) {
        this.arithmetic(type, type.getOpcode(108));
    }

    public void rem(Type type) {
        this.arithmetic(type, type.getOpcode(112));
    }

    public void neg(Type type) {
        this.mv.visitInsn(type.getOpcode(116));
    }

    public void iinc(int local, int amount) {
        this.mv.visitIincInsn(local, amount);
    }

    public void inverts(Type type) {
        if (type.equals((Object)AClass.LONG_ACLASS)) {
            this.push(-1L);
        } else {
            this.push(-1);
        }
        this.mv.visitInsn(type.getOpcode(130));
    }

    public void bitAnd(Type type) {
        this.mv.visitInsn(type.getOpcode(126));
    }

    public void bitOr(Type type) {
        this.mv.visitInsn(type.getOpcode(128));
    }

    public void bitXor(Type type) {
        this.mv.visitInsn(type.getOpcode(130));
    }

    public void leftShift(Type type) {
        this.mv.visitInsn(type.getOpcode(120));
    }

    public void rightShift(Type type) {
        this.mv.visitInsn(type.getOpcode(122));
    }

    public void unsignedRightShift(Type type) {
        this.mv.visitInsn(type.getOpcode(124));
    }

    public void newArray(Type type) {
        int typ;
        switch (type.getSort()) {
            case 1: {
                typ = 4;
                break;
            }
            case 2: {
                typ = 5;
                break;
            }
            case 3: {
                typ = 8;
                break;
            }
            case 4: {
                typ = 9;
                break;
            }
            case 5: {
                typ = 10;
                break;
            }
            case 6: {
                typ = 6;
                break;
            }
            case 7: {
                typ = 11;
                break;
            }
            case 8: {
                typ = 7;
                break;
            }
            default: {
                this.typeInsn(189, type);
                return;
            }
        }
        this.mv.visitIntInsn(188, typ);
    }

    public void multiANewArrayInsn(Type type, int dims) {
        this.mv.visitMultiANewArrayInsn(type.getDescriptor(), dims);
    }

    public void arrayLoad(Type type) {
        this.mv.visitInsn(type.getOpcode(46));
    }

    public void arrayStore(Type type) {
        this.mv.visitInsn(type.getOpcode(79));
    }

    public void arrayLength() {
        this.mv.visitInsn(190);
    }

    public void ifCmp(Type type, int mode, Label label) {
        switch (type.getSort()) {
            case 7: {
                this.mv.visitInsn(148);
                break;
            }
            case 8: {
                this.mv.visitInsn(mode == 156 || mode == 157 ? 152 : 151);
                break;
            }
            case 6: {
                this.mv.visitInsn(mode == 156 || mode == 157 ? 150 : 149);
                break;
            }
            case 9: 
            case 10: {
                switch (mode) {
                    case 153: {
                        this.mv.visitJumpInsn(165, label);
                        return;
                    }
                    case 154: {
                        this.mv.visitJumpInsn(166, label);
                        return;
                    }
                }
                throw new IllegalArgumentException("Bad comparison for type " + type);
            }
            default: {
                int intOp = -1;
                switch (mode) {
                    case 153: {
                        intOp = 159;
                        break;
                    }
                    case 154: {
                        intOp = 160;
                        break;
                    }
                    case 156: {
                        intOp = 162;
                        break;
                    }
                    case 155: {
                        intOp = 161;
                        break;
                    }
                    case 158: {
                        intOp = 164;
                        break;
                    }
                    case 157: {
                        intOp = 163;
                    }
                }
                this.mv.visitJumpInsn(intOp, label);
                return;
            }
        }
        this.mv.visitJumpInsn(mode, label);
    }

    public void ifZCmp(int mode, Label label) {
        this.mv.visitJumpInsn(mode, label);
    }

    public void ifNull(Label label) {
        this.mv.visitJumpInsn(198, label);
    }

    public void ifNonNull(Label label) {
        this.mv.visitJumpInsn(199, label);
    }

    public void goTo(Label label) {
        this.mv.visitJumpInsn(167, label);
    }

    public void instanceOf(Type type) {
        this.typeInsn(193, type);
    }

    public void tryCatchBlock(Label tryStart, Label tryEnd, Label catchStart, Type exceptionType) {
        this.mv.visitTryCatchBlock(tryStart, tryEnd, catchStart, exceptionType == null ? null : exceptionType.getInternalName());
    }

    public void throwException() {
        this.mv.visitInsn(191);
    }

    public void monitorEnter() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"execute monitorenter");
        }
        this.mv.visitInsn(194);
    }

    public void monitorExit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"execute monitorexit");
        }
        this.mv.visitInsn(195);
    }

    public void pop() {
        this.pop(1);
    }

    public void pop(int time) {
        while (time > 0) {
            this.getMv().visitInsn(87);
            --time;
        }
    }

    public void returnInsn() {
        this.getMv().visitInsn(177);
    }

    public void returnInsn(Type type) {
        this.getMv().visitInsn(type.getOpcode(172));
    }

    public void declarationVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.getMv().visitLocalVariable(name, desc, null, start, end, index);
    }

    public void maxs(int stack, int locals) {
        log.debug((Object)("Method : " + this.method.getMethodEntity().getMethodString() + " Maxs(" + "stack:" + stack + " locals:" + locals + ")"));
        this.getMv().visitMaxs(stack, locals);
    }

    public void endMethod() {
        this.getMv().visitEnd();
        OperatorFactory.resetListener();
    }
}

