/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.asm;

import jw.asmsupport.clazz.AClass;
import jw.asmsupport.exception.InstructionException;
import jw.asmsupport.utils.Stack;
import jw.asmsupport.utils.Stackable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class StackLocalMethodVisitor
implements MethodVisitor,
Opcodes {
    private static Log log = LogFactory.getLog(StackLocalMethodVisitor.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private Stack stack;
    private MethodVisitor mv;
    private Type[] nextPushTypes;

    public Stack getStack() {
        return this.stack;
    }

    private Type[] triggerPushStack() {
        if (this.nextPushTypes == null) {
            return null;
        }
        this.stack.push(this.nextPushTypes);
        Type[] pushed = this.nextPushTypes;
        this.nextPushTypes = null;
        return pushed;
    }

    void setNextPushTypes(Type ... types) {
        this.nextPushTypes = types;
    }

    public StackLocalMethodVisitor(MethodVisitor mv, Stack stack) {
        this.stack = stack;
        this.mv = mv;
    }

    private void stackLocalOperator(int opcode) {
        this.stackLocalOperator(opcode, -1);
    }

    private void stackLocalOperator(int opcode, int popNum) {
        switch (opcode) {
            case 0: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Instruction : NOP");
                break;
            }
            case 1: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ACONST_NULL");
                }
                if (this.nextPushTypes != null) break;
                this.nextPushTypes = new Type[]{OBJECT_TYPE};
                break;
            }
            case 2: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ICONST_M1");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 3: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ICONST_0");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 4: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ICONST_1");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 5: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ICONST_2");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 6: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ICONST_3");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 7: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ICONST_4");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 8: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ICONST_5");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 9: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LCONST_0");
                }
                this.nextPushTypes = new Type[]{Type.LONG_TYPE};
                break;
            }
            case 10: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LCONST_1");
                }
                this.nextPushTypes = new Type[]{Type.LONG_TYPE};
                break;
            }
            case 11: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FCONST_0");
                }
                this.nextPushTypes = new Type[]{Type.FLOAT_TYPE};
                break;
            }
            case 12: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FCONST_1");
                }
                this.nextPushTypes = new Type[]{Type.FLOAT_TYPE};
                break;
            }
            case 13: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FCONST_2");
                }
                this.nextPushTypes = new Type[]{Type.FLOAT_TYPE};
                break;
            }
            case 14: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DCONST_0");
                }
                this.nextPushTypes = new Type[]{Type.DOUBLE_TYPE};
                break;
            }
            case 15: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DCONST_1");
                }
                this.nextPushTypes = new Type[]{Type.DOUBLE_TYPE};
                break;
            }
            case 16: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : BIPUSH");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 17: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : SIPUSH");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 18: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LDC");
                }
                if (this.nextPushTypes != null) break;
                throw new InternalError("please reference a type");
            }
            case 21: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ILOAD");
                }
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 22: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LLOAD");
                }
                this.nextPushTypes = new Type[]{Type.LONG_TYPE};
                break;
            }
            case 23: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FLOAD");
                }
                this.nextPushTypes = new Type[]{Type.FLOAT_TYPE};
                break;
            }
            case 24: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DLOAD");
                }
                this.nextPushTypes = new Type[]{Type.DOUBLE_TYPE};
                break;
            }
            case 25: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ALOAD");
                }
                if (this.nextPushTypes != null) break;
                this.nextPushTypes = new Type[]{OBJECT_TYPE};
                break;
            }
            case 46: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IALOAD");
                }
                this.stack.pop();
                this.stack.pop();
                this.nextPushTypes = new Type[]{Type.INT_TYPE};
                break;
            }
            case 47: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LALOAD");
                }
                this.stack.pop();
                this.stack.pop();
                this.nextPushTypes = new Type[]{Type.LONG_TYPE};
                break;
            }
            case 48: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FALOAD");
                }
                this.stack.pop();
                this.stack.pop();
                this.nextPushTypes = new Type[]{Type.FLOAT_TYPE};
                break;
            }
            case 49: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DALOAD");
                }
                this.stack.pop();
                this.stack.pop();
                this.nextPushTypes = new Type[]{Type.DOUBLE_TYPE};
                break;
            }
            case 50: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : AALOAD");
                }
                this.stack.pop();
                Stackable top = this.stack.pop();
                Type nextEleType = Type.getType((String)top.getType().getDescriptor().substring(1));
                this.setNextPushTypes(nextEleType);
                break;
            }
            case 51: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : BALOAD");
                }
                this.stack.pop();
                this.stack.pop();
                this.nextPushTypes = new Type[]{Type.BYTE_TYPE};
                break;
            }
            case 52: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : CALOAD");
                }
                this.stack.pop();
                this.stack.pop();
                this.nextPushTypes = new Type[]{Type.CHAR_TYPE};
                break;
            }
            case 53: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : SALOAD");
                }
                this.stack.pop();
                this.stack.pop();
                this.nextPushTypes = new Type[]{Type.SHORT_TYPE};
                break;
            }
            case 54: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ISTORE");
                }
                this.stack.pop();
                break;
            }
            case 55: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LSTORE");
                }
                this.stack.pop();
                break;
            }
            case 56: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FSTORE");
                }
                this.stack.pop();
                break;
            }
            case 57: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DSTORE");
                }
                this.stack.pop();
                break;
            }
            case 58: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ASTORE");
                }
                this.stack.pop();
                break;
            }
            case 79: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IASTORE");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 80: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LASTORE");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 81: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FASTORE");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 82: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DASTORE");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 83: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : AASTORE");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 84: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : BASTORE");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 85: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : CASTORE");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 86: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : SASTORE");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 87: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : POP");
                }
                this.stack.pop();
                break;
            }
            case 88: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : POP2");
                }
                this.stack.pop(2);
                break;
            }
            case 89: {
                Stackable top;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DUP");
                }
                if ((top = this.stack.peek()).getSize() == 1) {
                    this.setNextPushTypes(top.getType());
                    break;
                }
                throw new InstructionException("two word value off the operand stack", 89, (Stack)this.stack.clone());
            }
            case 90: {
                Stackable top;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DUP_X1");
                }
                if ((top = this.stack.peek()).getSize() == 1) {
                    this.stack.insert(2, top);
                    break;
                }
                throw new InstructionException("two word value off the operand stack", 90, (Stack)this.stack.clone());
            }
            case 91: {
                Stackable top;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DUP_X2");
                }
                if ((top = this.stack.peek()).getSize() == 1) {
                    this.stack.insert(3, top);
                    break;
                }
                throw new InstructionException("two word value off the operand stack", 91, (Stack)this.stack.clone());
            }
            case 92: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DUP2");
                }
                if (this.stack.peek().getSize() == 2) {
                    this.setNextPushTypes(this.stack.peek().getType());
                    break;
                }
                if (this.stack.peek().getSize() == 1 && this.stack.peek(1).getSize() == 1) {
                    this.setNextPushTypes(this.stack.peek(1).getType(), this.stack.peek().getType());
                    break;
                }
                throw new InstructionException("cannot dup top two from stack", 92, (Stack)this.stack.clone());
            }
            case 93: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DUP2_X1");
                }
                if (this.stack.peek().getSize() == 2) {
                    this.stack.insert(2, this.stack.peek());
                    break;
                }
                if (this.stack.peek().getSize() == 1 && this.stack.peek(1).getSize() == 1) {
                    this.stack.insert(2, this.stack.peek(1));
                    this.stack.insert(2, this.stack.peek());
                    break;
                }
                throw new InstructionException("cannot dup top two from stack", 93, (Stack)this.stack.clone());
            }
            case 94: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DUP2_X2");
                }
                if (this.stack.peek().getSize() == 2) {
                    this.stack.insert(3, this.stack.peek());
                    break;
                }
                if (this.stack.peek().getSize() == 1 && this.stack.peek(1).getSize() == 1) {
                    this.stack.insert(3, this.stack.peek(1));
                    this.stack.insert(3, this.stack.peek());
                    break;
                }
                throw new InstructionException("cannot dup top two from stack", 94, (Stack)this.stack.clone());
            }
            case 95: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : SWAP");
                }
                Stackable top = this.stack.peek();
                this.stack.pop();
                this.stack.insert(1, top);
                break;
            }
            case 96: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IADD");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 97: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LADD");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 98: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FADD");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.FLOAT_TYPE);
                break;
            }
            case 99: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DADD");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.DOUBLE_TYPE);
                break;
            }
            case 100: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ISUB");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 101: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LSUB");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 102: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FSUB");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.FLOAT_TYPE);
                break;
            }
            case 103: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DSUB");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.DOUBLE_TYPE);
                break;
            }
            case 104: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IMUL");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 105: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LMUL");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 106: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FMUL");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.FLOAT_TYPE);
                break;
            }
            case 107: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DMUL");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.DOUBLE_TYPE);
                break;
            }
            case 108: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IDIV");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 109: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LDIV");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 110: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FDIV");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.FLOAT_TYPE);
                break;
            }
            case 111: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DDIV");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.DOUBLE_TYPE);
                break;
            }
            case 112: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IREM");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 113: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LREM");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 114: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FREM");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.FLOAT_TYPE);
                break;
            }
            case 115: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DREM");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.DOUBLE_TYPE);
                break;
            }
            case 116: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : INEG");
                }
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 117: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LNEG");
                }
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 118: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FNEG");
                }
                this.stack.pop();
                this.setNextPushTypes(Type.FLOAT_TYPE);
                break;
            }
            case 119: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DNEG");
                }
                this.stack.pop();
                this.setNextPushTypes(Type.DOUBLE_TYPE);
                break;
            }
            case 120: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ISHL");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 121: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LSHL");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 122: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ISHR");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 123: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LSHR");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 124: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IUSHR");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 125: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LUSHR");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 126: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IAND");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 127: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LAND");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 128: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IOR");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 129: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LOR");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 130: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IXOR");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.INT_TYPE);
                break;
            }
            case 131: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LXOR");
                }
                this.stack.pop();
                this.stack.pop();
                this.setNextPushTypes(Type.LONG_TYPE);
                break;
            }
            case 132: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Instruction : IINC");
                break;
            }
            case 133: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : I2L");
                }
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 134: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : I2F");
                }
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 135: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : I2D");
                }
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 136: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : L2I");
                }
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 137: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : L2F");
                }
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 138: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : L2D");
                }
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 139: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : F2I");
                }
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 140: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : F2L");
                }
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 141: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : F2D");
                }
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 142: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : D2I");
                }
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 143: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : D2L");
                }
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 144: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : D2F");
                }
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 145: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : I2B");
                }
                this.stack.pop();
                this.stack.push(Type.BYTE_TYPE);
                break;
            }
            case 146: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : I2C");
                }
                this.stack.pop();
                this.stack.push(Type.CHAR_TYPE);
                break;
            }
            case 147: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : I2S");
                }
                this.stack.pop();
                this.stack.push(Type.SHORT_TYPE);
                break;
            }
            case 148: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LCMP");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 149: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FCMPL");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 150: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FCMPG");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 151: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DCMPL");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 152: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DCMPG");
                }
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 153: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IFEQ");
                }
                this.stack.pop();
                break;
            }
            case 154: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IFNE");
                }
                this.stack.pop();
                break;
            }
            case 155: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IFLT");
                }
                this.stack.pop();
                break;
            }
            case 156: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IFGE");
                }
                this.stack.pop();
                break;
            }
            case 157: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IFGT");
                }
                this.stack.pop();
                break;
            }
            case 158: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IFLE");
                }
                this.stack.pop();
                break;
            }
            case 159: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IF_ICMPEQ");
                }
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 160: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IF_ICMPNE");
                }
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 161: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IF_ICMPLT");
                }
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 162: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IF_ICMPGE");
                }
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 163: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IF_ICMPGT");
                }
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 164: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IF_ICMPLE");
                }
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 165: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IF_ACMPEQ");
                }
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 166: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IF_ACMPNE");
                }
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 167: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Instruction : GOTO");
                break;
            }
            case 168: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Instruction : JSR");
                break;
            }
            case 169: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Instruction : RET");
                break;
            }
            case 170: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Instruction : TABLESWITCH");
                break;
            }
            case 171: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Instruction : LOOKUPSWITCH");
                break;
            }
            case 172: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IRETURN");
                }
                this.stack.pop();
                break;
            }
            case 173: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : LRETURN");
                }
                this.stack.pop();
                break;
            }
            case 174: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : FRETURN");
                }
                this.stack.pop();
                break;
            }
            case 175: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : DRETURN");
                }
                this.stack.pop();
                break;
            }
            case 176: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ARETURN");
                }
                this.stack.pop();
                break;
            }
            case 177: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Instruction : RETURN");
                break;
            }
            case 178: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : GETSTATIC");
                }
                if (this.nextPushTypes != null) break;
                throw new InternalError("please reference a type");
            }
            case 179: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : PUTSTATIC");
                }
                this.stack.pop();
                break;
            }
            case 180: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : GETFIELD");
                }
                if (this.nextPushTypes != null) break;
                throw new InternalError("please reference a type");
            }
            case 181: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : PUTFIELD");
                }
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 182: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : INVOKEVIRTUAL");
                }
                this.stack.pop(popNum);
                this.stack.pop();
                break;
            }
            case 183: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : INVOKESPECIAL");
                }
                this.stack.pop(popNum);
                this.stack.pop();
                break;
            }
            case 184: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : INVOKESTATIC");
                }
                this.stack.pop(popNum);
                break;
            }
            case 185: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : INVOKEINTERFACE");
                }
                this.stack.pop(popNum);
                this.stack.pop();
                break;
            }
            case 186: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : INVOKEDYNAMIC");
                }
                this.stack.pop(popNum);
                this.stack.pop();
                break;
            }
            case 187: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Instruction : NEW");
                break;
            }
            case 188: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : NEWARRAY");
                }
                this.stack.pop();
                break;
            }
            case 189: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ANEWARRAY");
                }
                this.stack.pop();
                break;
            }
            case 190: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ARRAYLENGTH");
                }
                this.setNextPushTypes(Type.INT_TYPE);
                this.stack.pop();
                break;
            }
            case 191: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : ATHROW");
                }
                this.stack.pop();
                break;
            }
            case 192: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : CHECKCAST");
                }
                this.stack.pop();
                break;
            }
            case 193: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : INSTANCEOF");
                }
                this.stack.pop();
                break;
            }
            case 194: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : MONITORENTER");
                }
                this.stack.pop();
                break;
            }
            case 195: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : MONITOREXIT");
                }
                this.stack.pop();
                break;
            }
            case 197: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : MULTIANEWARRAY");
                }
                this.stack.pop(popNum);
                break;
            }
            case 198: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IFNULL");
                }
                this.stack.pop();
                break;
            }
            case 199: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Instruction : IFNONNULL");
                }
                this.stack.pop();
                break;
            }
            default: {
                throw new InternalError("cannot found instruction " + opcode);
            }
        }
        this.triggerPushStack();
        if (opcode != 0) {
            this.stack.printState();
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this.mv.visitAnnotationDefault();
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.mv.visitAnnotation(desc, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        return this.mv.visitParameterAnnotation(parameter, desc, visible);
    }

    public void visitAttribute(Attribute attr) {
        this.mv.visitAttribute(attr);
    }

    public void visitCode() {
        this.mv.visitCode();
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.mv.visitFrame(type, nLocal, local, nStack, stack);
    }

    public void visitInsn(int opcode) {
        this.stackLocalOperator(opcode);
        this.mv.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 188) {
            Type arrayType = Type.getType((String)("[" + this.getTypeByOperand(operand).getDescriptor()));
            this.setNextPushTypes(arrayType);
        }
        this.stackLocalOperator(opcode);
        this.mv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.stackLocalOperator(opcode);
        this.mv.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 193) {
            this.setNextPushTypes(Type.INT_TYPE);
        } else {
            this.setNextPushTypes(Type.getObjectType((String)type));
        }
        this.stackLocalOperator(opcode);
        this.mv.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode == 178 || opcode == 180) {
            Type type = Type.getType((String)desc);
            this.setNextPushTypes(type);
        }
        this.stackLocalOperator(opcode);
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        Type returnType = Type.getReturnType((String)desc);
        if (!Type.VOID_TYPE.equals((Object)returnType)) {
            this.setNextPushTypes(returnType);
        }
        Type[] argTypes = Type.getArgumentTypes((String)desc);
        this.stackLocalOperator(opcode, argTypes.length);
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.stackLocalOperator(opcode);
        this.mv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.mv.visitLabel(label);
    }

    public void visitLdcInsn(Object cst) {
        Class<?> ctsCls = cst.getClass();
        if (ctsCls.equals(Type.class)) {
            this.setNextPushTypes(AClass.CLASS_ACLASS.getType());
        } else if (ctsCls.equals(Integer.class)) {
            this.setNextPushTypes(Type.INT_TYPE);
        } else if (ctsCls.equals(Float.class)) {
            this.setNextPushTypes(Type.FLOAT_TYPE);
        } else if (ctsCls.equals(Long.class)) {
            this.setNextPushTypes(Type.LONG_TYPE);
        } else if (ctsCls.equals(Double.class)) {
            this.setNextPushTypes(Type.DOUBLE_TYPE);
        } else if (ctsCls.equals(String.class)) {
            this.setNextPushTypes(AClass.STRING_ACLASS.getType());
        }
        this.stackLocalOperator(18);
        this.mv.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        this.stackLocalOperator(132);
        this.mv.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.stackLocalOperator(170);
        this.mv.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.stackLocalOperator(171);
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.setNextPushTypes(Type.getType((String)desc));
        this.stackLocalOperator(197, dims);
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.mv.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        this.mv.visitLineNumber(line, start);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, maxLocals);
    }

    public void visitEnd() {
        this.mv.visitEnd();
    }

    private Type getTypeByOperand(int order) {
        switch (order) {
            case 4: {
                return Type.BOOLEAN_TYPE;
            }
            case 5: {
                return Type.CHAR_TYPE;
            }
            case 8: {
                return Type.BYTE_TYPE;
            }
            case 9: {
                return Type.SHORT_TYPE;
            }
            case 10: {
                return Type.INT_TYPE;
            }
            case 6: {
                return Type.FLOAT_TYPE;
            }
            case 11: {
                return Type.LONG_TYPE;
            }
            case 7: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new InternalError();
    }
}

