/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.asm.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jw.asmsupport.asm.proxy.VisitFieldInsnAdapter;
import jw.asmsupport.asm.proxy.VisitIincInsnAdapter;
import jw.asmsupport.asm.proxy.VisitInsnAdapter;
import jw.asmsupport.asm.proxy.VisitIntInsnAdapter;
import jw.asmsupport.asm.proxy.VisitLdcInsnAdapter;
import jw.asmsupport.asm.proxy.VisitMethodArgumentStore;
import jw.asmsupport.asm.proxy.VisitMethodInsnAdapter;
import jw.asmsupport.asm.proxy.VisitMultiANewArrayInsnAdapter;
import jw.asmsupport.asm.proxy.VisitTypeInsnAdapter;
import jw.asmsupport.asm.proxy.VisitVarInsnAdapter;
import jw.asmsupport.asm.proxy.VisitXInsnAdapter;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.creator.ClassModifier;
import jw.asmsupport.creator.IMethodCreator;
import jw.asmsupport.utils.ModifierUtils;
import org.apache.commons.collections.CollectionUtils;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassModifierClassAdapter
extends ClassAdapter {
    private List<VisitMethodArgumentStore> vma = new ArrayList<VisitMethodArgumentStore>();
    private List<IMethodCreator> needModify;
    private ClassModifier classModifer;
    private String classInternalName;
    private Map<String, List<VisitXInsnAdapter>> superConstructorMap;

    public ClassModifierClassAdapter(ClassVisitor cv, ClassModifier classModifer) {
        super(cv);
        this.classModifer = classModifer;
        this.needModify = new LinkedList<IMethodCreator>();
        if (classModifer.getMethodModifiers() != null) {
            CollectionUtils.addAll(this.needModify, classModifer.getMethodModifiers().iterator());
        }
    }

    public List<VisitXInsnAdapter> getSuperConstructorOperators(String desc) {
        return this.superConstructorMap.get(desc);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classInternalName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Object methodVisitor;
        if (!this.isModified(name, desc)) {
            methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        } else {
            if (ModifierUtils.isFinal(access)) {
                throw new InternalError("method [" + name + "] is final cannot modifier.");
            }
            this.vma.add(new VisitMethodArgumentStore(access, name, desc, signature, exceptions));
            if (!ModifierUtils.isPrivate(access)) {
                if (ModifierUtils.isProtected(access)) {
                    access -= 4;
                } else if (ModifierUtils.isPublic(access)) {
                    --access;
                }
                access += 2;
            }
            if (name.equals("<init>")) {
                name = "&init&";
                methodVisitor = new ConstructorVisitor(super.visitMethod(access, name + "@ByProxy", desc, signature, exceptions), desc);
            } else {
                if (name.equals("<clinit>")) {
                    name = "&clinit&";
                }
                methodVisitor = super.visitMethod(access, name + "@ByProxy", desc, signature, exceptions);
            }
        }
        return new InvocationRenameMethodAdapter((MethodVisitor)methodVisitor);
    }

    @Deprecated
    private boolean containAndRemove(String name, String desc) {
        IMethodCreator imm = null;
        for (IMethodCreator m : this.needModify) {
            if (!this.methodEqual(m, name, desc)) continue;
            imm = m;
            break;
        }
        if (imm != null) {
            this.needModify.remove(imm);
            return true;
        }
        return false;
    }

    private boolean isModified(String name, String desc) {
        IMethodCreator imm = null;
        for (IMethodCreator m : this.needModify) {
            if (!this.methodEqual(m, name, desc)) continue;
            imm = m;
            break;
        }
        return imm != null;
    }

    private boolean methodEqual(IMethodCreator mm, String name, String desc) {
        Type[] types;
        if (!mm.getName().equals(name)) {
            return false;
        }
        AClass[] mmArgs = mm.getArguments();
        if (mmArgs.length != (types = Type.getArgumentTypes((String)desc)).length) {
            return false;
        }
        for (int i = 0; i < mmArgs.length; ++i) {
            if (types[i].equals((Object)mmArgs[i].getType())) continue;
            return false;
        }
        return true;
    }

    public void visitEnd() {
        this.classModifer.modify(this.superConstructorMap);
        super.visitEnd();
    }

    private void addSuperConstructorMap(String constructorDesc, VisitXInsnAdapter operator) {
        if (this.superConstructorMap == null) {
            this.superConstructorMap = new HashMap<String, List<VisitXInsnAdapter>>();
        }
        if (this.superConstructorMap.containsKey(constructorDesc)) {
            List<VisitXInsnAdapter> operators = this.superConstructorMap.get(constructorDesc);
            operators.add(operator);
        } else {
            ArrayList<VisitXInsnAdapter> operators = new ArrayList<VisitXInsnAdapter>();
            operators.add(operator);
            this.superConstructorMap.put(constructorDesc, operators);
        }
    }

    class ConstructorVisitor
    extends MethodAdapter {
        private boolean invokedSuper;
        private String desc;

        public ConstructorVisitor(MethodVisitor mv, String desc) {
            super(mv);
            this.invokedSuper = false;
            this.desc = desc;
        }

        public void visitInsn(int opcode) {
            if (this.invokedSuper) {
                super.visitInsn(opcode);
            } else {
                ClassModifierClassAdapter.this.addSuperConstructorMap(this.desc, new VisitInsnAdapter(opcode));
            }
        }

        public void visitIntInsn(int opcode, int operand) {
            if (this.invokedSuper) {
                super.visitIntInsn(opcode, operand);
            } else {
                ClassModifierClassAdapter.this.addSuperConstructorMap(this.desc, new VisitIntInsnAdapter(operand, operand));
            }
        }

        public void visitVarInsn(int opcode, int var) {
            if (this.invokedSuper) {
                super.visitVarInsn(opcode, var);
            } else {
                ClassModifierClassAdapter.this.addSuperConstructorMap(this.desc, new VisitVarInsnAdapter(opcode, var));
            }
        }

        public void visitTypeInsn(int opcode, String type) {
            if (this.invokedSuper) {
                super.visitTypeInsn(opcode, type);
            } else {
                ClassModifierClassAdapter.this.addSuperConstructorMap(this.desc, new VisitTypeInsnAdapter(opcode, type));
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (this.invokedSuper) {
                super.visitFieldInsn(opcode, owner, name, desc);
            } else {
                ClassModifierClassAdapter.this.addSuperConstructorMap(desc, new VisitFieldInsnAdapter(opcode, owner, name, desc));
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (this.invokedSuper) {
                super.visitMethodInsn(opcode, owner, name, desc);
            } else {
                ClassModifierClassAdapter.this.addSuperConstructorMap(desc, new VisitMethodInsnAdapter(opcode, owner, name, desc));
            }
            if (opcode == 183) {
                this.invokedSuper = true;
            }
        }

        public void visitLdcInsn(Object cst) {
            if (this.invokedSuper) {
                super.visitLdcInsn(cst);
            } else {
                ClassModifierClassAdapter.this.addSuperConstructorMap(this.desc, new VisitLdcInsnAdapter(cst));
            }
        }

        public void visitIincInsn(int var, int increment) {
            if (this.invokedSuper) {
                super.visitIincInsn(var, increment);
            } else {
                ClassModifierClassAdapter.this.addSuperConstructorMap(this.desc, new VisitIincInsnAdapter(var, increment));
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            if (this.invokedSuper) {
                super.visitMultiANewArrayInsn(desc, dims);
            } else {
                ClassModifierClassAdapter.this.addSuperConstructorMap(desc, new VisitMultiANewArrayInsnAdapter(desc, dims));
            }
        }
    }

    private class InvocationRenameMethodAdapter
    extends MethodAdapter {
        public InvocationRenameMethodAdapter(MethodVisitor mv) {
            super(mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (owner.equals(ClassModifierClassAdapter.this.classInternalName) && ClassModifierClassAdapter.this.isModified(name, desc)) {
                super.visitMethodInsn(opcode, owner, name + "@ByProxy", desc);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }
    }
}

