/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.asm.proxy;

import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;

public class ClassNameRefactorAdapter
extends ClassAdapter {
    private String originalName;
    private String JVMProxyClassName;

    public ClassNameRefactorAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.JVMProxyClassName = name + "";
        this.originalName = name;
        super.visit(version, access, this.JVMProxyClassName, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new ClassNameRefactorVisitor(super.visitMethod(access, name, desc, signature, exceptions));
    }

    public String getJVMProxyClassName() {
        return this.JVMProxyClassName;
    }

    class ClassNameRefactorVisitor
    extends MethodAdapter {
        public ClassNameRefactorVisitor(MethodVisitor mv) {
            super(mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (ClassNameRefactorAdapter.this.originalName.equals(owner)) {
                owner = ClassNameRefactorAdapter.this.JVMProxyClassName;
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (ClassNameRefactorAdapter.this.originalName.equals(owner)) {
                owner = ClassNameRefactorAdapter.this.JVMProxyClassName;
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (desc.equals("L" + ClassNameRefactorAdapter.this.originalName + ";")) {
                desc = "L" + ClassNameRefactorAdapter.this.JVMProxyClassName + ";";
            }
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }
}

