/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.block;

import java.util.ArrayList;
import java.util.List;
import jw.asmsupport.Crementable;
import jw.asmsupport.Executeable;
import jw.asmsupport.Parameterized;
import jw.asmsupport.asm.InstructionHelper;
import jw.asmsupport.block.IBlockOperators;
import jw.asmsupport.block.Synchronized;
import jw.asmsupport.block.control.Catch;
import jw.asmsupport.block.control.DoWhileLoop;
import jw.asmsupport.block.control.Finally;
import jw.asmsupport.block.control.ForEachLoop;
import jw.asmsupport.block.control.IF;
import jw.asmsupport.block.control.ILoop;
import jw.asmsupport.block.control.Try;
import jw.asmsupport.block.control.WhileLoop;
import jw.asmsupport.block.method.SuperMethodBody;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.clazz.NewMemberClass;
import jw.asmsupport.definition.AbstractExecuteable;
import jw.asmsupport.definition.method.Method;
import jw.asmsupport.definition.variable.GlobalVariable;
import jw.asmsupport.definition.variable.IVariable;
import jw.asmsupport.definition.variable.LocalVariable;
import jw.asmsupport.definition.variable.MemberVariable;
import jw.asmsupport.definition.variable.SuperVariable;
import jw.asmsupport.definition.variable.ThisVariable;
import jw.asmsupport.entity.LocalVariableEntity;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.exception.MethodInvokeException;
import jw.asmsupport.exception.UnreachableCode;
import jw.asmsupport.exception.VerifyErrorException;
import jw.asmsupport.operators.AbstractOperator;
import jw.asmsupport.operators.BlockEndFlag;
import jw.asmsupport.operators.InstanceofOperator;
import jw.asmsupport.operators.NoneOperator;
import jw.asmsupport.operators.Return;
import jw.asmsupport.operators.StringAppender;
import jw.asmsupport.operators.Throw;
import jw.asmsupport.operators.array.ArrayLength;
import jw.asmsupport.operators.array.ArrayLoader;
import jw.asmsupport.operators.array.ArrayStorer;
import jw.asmsupport.operators.array.ArrayValue;
import jw.asmsupport.operators.asmdirect.GOTO;
import jw.asmsupport.operators.assign.Assigner;
import jw.asmsupport.operators.assign.GlobalVariableAssigner;
import jw.asmsupport.operators.assign.LocalVariableAssigner;
import jw.asmsupport.operators.checkcast.CheckCast;
import jw.asmsupport.operators.logical.LogicalAnd;
import jw.asmsupport.operators.logical.LogicalOr;
import jw.asmsupport.operators.logical.LogicalXor;
import jw.asmsupport.operators.logical.Not;
import jw.asmsupport.operators.logical.ShortCircuitAnd;
import jw.asmsupport.operators.logical.ShortCircuitOr;
import jw.asmsupport.operators.method.CommonMethodInvoker;
import jw.asmsupport.operators.method.ConstructorInvoker;
import jw.asmsupport.operators.method.MethodInvoker;
import jw.asmsupport.operators.method.StaticMethodInvoker;
import jw.asmsupport.operators.numerical.arithmetic.Addition;
import jw.asmsupport.operators.numerical.arithmetic.Division;
import jw.asmsupport.operators.numerical.arithmetic.Modulus;
import jw.asmsupport.operators.numerical.arithmetic.Multiplication;
import jw.asmsupport.operators.numerical.arithmetic.Subtraction;
import jw.asmsupport.operators.numerical.bitwise.BitAnd;
import jw.asmsupport.operators.numerical.bitwise.BitOr;
import jw.asmsupport.operators.numerical.bitwise.BitXor;
import jw.asmsupport.operators.numerical.bitwise.Inverts;
import jw.asmsupport.operators.numerical.bitwise.LeftShift;
import jw.asmsupport.operators.numerical.bitwise.RightShift;
import jw.asmsupport.operators.numerical.bitwise.UnsignedRightShift;
import jw.asmsupport.operators.numerical.crement.AfterDecrement;
import jw.asmsupport.operators.numerical.crement.AfterIncrement;
import jw.asmsupport.operators.numerical.crement.BeforeDecrement;
import jw.asmsupport.operators.numerical.crement.BeforeIncrement;
import jw.asmsupport.operators.numerical.posinegative.Negative;
import jw.asmsupport.operators.relational.Equal;
import jw.asmsupport.operators.relational.GreaterEqual;
import jw.asmsupport.operators.relational.GreaterThan;
import jw.asmsupport.operators.relational.LessEqual;
import jw.asmsupport.operators.relational.LessThan;
import jw.asmsupport.operators.relational.NotEqual;
import jw.asmsupport.operators.ternary.TernaryOperator;
import jw.asmsupport.operators.util.OperatorFactory;
import jw.asmsupport.operators.util.ThrowExceptionContainer;
import jw.asmsupport.operators.variable.LocalVariableCreator;
import jw.asmsupport.utils.Scope;
import jw.asmsupport.utils.ScopeLogicVariable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Type;

public abstract class ProgramBlock
extends AbstractExecuteable
implements IBlockOperators,
Cloneable {
    private static Log log = LogFactory.getLog(ProgramBlock.class);
    private ProgramBlock executeBlock = this;
    protected Scope scope;
    protected ProgramBlock ownerBlock;
    private List<Executeable> executeQueue = new ArrayList<Executeable>();
    private List<Executeable> preExecuteQueue = new ArrayList<Executeable>();
    protected InstructionHelper insnHelper;
    protected Method method;
    protected boolean returned;
    private boolean whetherCheckUnreachableCode = true;
    private ThrowExceptionContainer throwExceptions;

    public void setExecuteBlock(ProgramBlock exeBlock) {
        this.executeBlock = exeBlock;
    }

    protected ProgramBlock getExecuteBlock() {
        return this.executeBlock;
    }

    public ThrowExceptionContainer getThrowExceptions() {
        return this.throwExceptions;
    }

    public void addException(AClass exception) {
        if (this.throwExceptions == null) {
            this.throwExceptions = new ThrowExceptionContainer();
        }
        this.throwExceptions.add(exception);
    }

    public void removeException(AClass exception) {
        if (this.throwExceptions != null) {
            this.throwExceptions.remove(exception);
        }
    }

    public boolean whetherCheckUnreachableCode() {
        return this.whetherCheckUnreachableCode;
    }

    public void setWhetherCheckUnreachableCode(boolean whetherCheckUnreachableCode) {
        this.whetherCheckUnreachableCode = whetherCheckUnreachableCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProgramBlock) {
            return this.scope == ((ProgramBlock)obj).scope;
        }
        return false;
    }

    public boolean isReturned() {
        return this.returned;
    }

    public void setReturned(boolean returned) {
        if (!this.returned || returned) {
            this.returned = returned;
        }
    }

    public List<Executeable> getPreExecuteInsn() {
        return this.preExecuteQueue;
    }

    public List<Executeable> getExecuteQueue() {
        return this.executeQueue;
    }

    public boolean isUnreachableCode(AbstractOperator currentOperator) {
        return this.isReturned();
    }

    protected abstract void init();

    public ProgramBlock getCopy() {
        try {
            return (ProgramBlock)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new ASMSupportException();
        }
    }

    public void clonerGenerate(ProgramBlock cloneTo) {
        ProgramBlock clone = this.getCopy();
        clone.setExecuteBlock(cloneTo);
        clone.generateInsn();
    }

    protected ProgramBlock() {
    }

    public abstract void generateInsn();

    @Override
    public void prepare() {
        this.init();
        this.generateInsn();
        new BlockEndFlag(this.getExecuteBlock());
    }

    protected void subBlockPrepare(ProgramBlock pb) {
        this.subBlockPrepare(pb, this);
    }

    protected void subBlockPrepare(ProgramBlock pb, ProgramBlock parentBlock) {
        pb.setInsnHelper(this.insnHelper);
        pb.setScope(new Scope(this.method.getLocals(), parentBlock.getScope()));
        pb.setOwnerBlock(parentBlock.getExecuteBlock());
        if (pb instanceof Try || pb instanceof Catch || pb instanceof Finally) {
            if (pb instanceof Try) {
                this.getMethod().setNearlyTryBlock((Try)pb);
            }
        } else {
            this.tiggerTryCatchPrepare();
            pb.prepare();
        }
        new BlockEndFlag(pb);
    }

    public void tiggerTryCatchPrepare() {
        Try nearlyTryBlock = this.getMethod().getNearlyTryBlock();
        if (nearlyTryBlock != null) {
            this.getMethod().setNearlyTryBlock(null);
            nearlyTryBlock.prepare();
            Finally finallyBlock = nearlyTryBlock.getFinallyBlock();
            for (Catch catchBlock = nearlyTryBlock.getCatchEntity(); catchBlock != null; catchBlock = catchBlock.getNextCatch()) {
                catchBlock.prepare();
            }
            if (finallyBlock != null) {
                try {
                    OperatorFactory.newOperator(NoneOperator.class, new Class[]{ProgramBlock.class}, this.getExecuteBlock());
                    finallyBlock.prepare();
                }
                catch (UnreachableCode uc) {
                    log.info((Object)"unreachable code");
                }
                catch (RuntimeException e) {
                    throw e;
                }
            }
        }
    }

    @Override
    public final void execute() {
        this.insnHelper.mark(this.getScope().getStart());
        this.insnHelper.nop();
        this.executing();
        this.insnHelper.mark(this.getScope().innerEnd());
        this.insnHelper.nop();
        this.insnHelper.mark(this.getScope().outerEnd());
    }

    public abstract void executing();

    public void addExe(Executeable exe) {
        this.getExecuteQueue().add(exe);
        this.getPreExecuteInsn().add(exe);
    }

    public void addAllExe(int index, List<Executeable> exes) {
        this.getExecuteQueue().addAll(index, exes);
        this.getPreExecuteInsn().addAll(index, exes);
    }

    public void removeExe(Executeable exe) {
        for (int i = this.getExecuteQueue().size() - 1; i >= 0; --i) {
            if (!this.getExecuteQueue().get(i).equals(exe)) continue;
            this.getExecuteQueue().remove(i);
            break;
        }
    }

    public void replaceExe(Executeable old, Executeable newp) {
        for (int i = this.getExecuteQueue().size() - 1; i >= 0; --i) {
            if (!this.getExecuteQueue().get(i).equals(old)) continue;
            this.getExecuteQueue().remove(i);
            this.getExecuteQueue().add(i, newp);
            break;
        }
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setInsnHelper(InstructionHelper insnHelper) {
        this.insnHelper = insnHelper;
        this.method = insnHelper.getMethod();
    }

    public void setOwnerBlock(ProgramBlock block) {
        this.ownerBlock = block;
    }

    public ProgramBlock getOwnerBlock() {
        return this.ownerBlock;
    }

    public Method getMethod() {
        return this.method;
    }

    public LocalVariable[] getMethodArguments() {
        return this.method.getArguments();
    }

    protected SuperMethodBody getMethodBody() {
        if (this instanceof SuperMethodBody) {
            return (SuperMethodBody)this;
        }
        return this.ownerBlock.getMethodBody();
    }

    public NewMemberClass getMethodOwner() {
        return this.method.getMethodOwner();
    }

    public InstructionHelper getInsnHelper() {
        return this.insnHelper;
    }

    private final LocalVariable createOnlyVariable(AClass aClass, String name, boolean anonymous) {
        if (!anonymous && StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("variable must be non-null if 'anonymous' is false");
        }
        LocalVariableEntity lve = new LocalVariableEntity(anonymous ? "anonymous" : name, 0, aClass);
        LocalVariableCreator lvc = OperatorFactory.newOperator(LocalVariableCreator.class, new Class[]{ProgramBlock.class, String.class, Type.class, Type.class}, this.getExecuteBlock(), anonymous ? null : name, aClass.getType(), aClass.getType());
        ScopeLogicVariable slv = lvc.getScopeLogicVariable();
        slv.setCompileOrder(this.insnHelper.getMethod().nextInsNumber());
        LocalVariable lv = new LocalVariable(lve);
        lv.setScopeLogicVar(slv);
        return lv;
    }

    protected final LocalVariable getLocalAnonymousVariableModel(AClass aClass) {
        return this.createOnlyVariable(aClass, "anonymous", true);
    }

    protected final LocalVariable getLocalVariableModel(String name, AClass aClass) {
        return this.createOnlyVariable(aClass, name, false);
    }

    @Override
    public final LocalVariable createVariable(String name, AClass aClass, boolean anonymous, Parameterized para) {
        if (aClass.isArray()) {
            throw new IllegalArgumentException(aClass + " is Array type exchange to createArrayVariable to create the array variable");
        }
        LocalVariable lv = this.createOnlyVariable(aClass, name, anonymous);
        if (para == null) {
            this.assign(lv, aClass.getDefaultValue());
        } else {
            this.assign(lv, para);
        }
        return lv;
    }

    @Override
    public final LocalVariable createArrayVariableWithAllocateDimension(String name, ArrayClass aClass, boolean anonymous, Parameterized ... allocateDim) {
        LocalVariable lv = this.createOnlyVariable(aClass, name, anonymous);
        if (allocateDim == null) {
            this.assign(lv, aClass.getDefaultValue());
        } else {
            this.assign(lv, this.newArray(aClass, allocateDim));
        }
        return lv;
    }

    @Override
    public final LocalVariable createArrayVariable(String name, ArrayClass aClass, boolean anonymous, Parameterized value) {
        LocalVariable lv = this.createOnlyVariable(aClass, name, anonymous);
        if (value == null) {
            this.assign(lv, aClass.getDefaultValue());
        } else {
            this.assign(lv, value);
        }
        return lv;
    }

    @Override
    public LocalVariable createArrayVariable(String name, ArrayClass aClass, boolean anonymous, Object parameterizedArray) {
        LocalVariable lv = this.createOnlyVariable(aClass, name, anonymous);
        if (parameterizedArray == null) {
            this.assign(lv, aClass.getDefaultValue());
        } else {
            this.assign(lv, this.getExecuteBlock().newArrayWithValue(aClass, parameterizedArray));
        }
        return lv;
    }

    @Override
    public final Assigner assign(MemberVariable mv, Parameterized val) {
        if (mv instanceof LocalVariable) {
            return OperatorFactory.newOperator(LocalVariableAssigner.class, new Class[]{ProgramBlock.class, LocalVariable.class, Parameterized.class}, this.getExecuteBlock(), (LocalVariable)mv, val);
        }
        if (mv instanceof GlobalVariable) {
            return OperatorFactory.newOperator(GlobalVariableAssigner.class, new Class[]{ProgramBlock.class, GlobalVariable.class, Parameterized.class}, this.getExecuteBlock(), (GlobalVariable)mv, val);
        }
        return null;
    }

    @Override
    public final ArrayValue newArray(ArrayClass aClass, Parameterized ... allocateDims) {
        return OperatorFactory.newOperator(ArrayValue.class, new Class[]{ProgramBlock.class, ArrayClass.class, Parameterized[].class}, this.getExecuteBlock(), aClass, allocateDims);
    }

    @Override
    public final ArrayValue newArrayWithValue(ArrayClass aClass, Object arrayObject) {
        return OperatorFactory.newOperator(ArrayValue.class, new Class[]{ProgramBlock.class, ArrayClass.class, Object.class}, this.getExecuteBlock(), aClass, arrayObject);
    }

    @Override
    public final ArrayValue newArrayWithValue(ArrayClass aClass, Parameterized[] values) {
        return this.newArrayWithValue(aClass, (Object)values);
    }

    @Override
    public final ArrayValue newArrayWithValue(ArrayClass aClass, Parameterized[][] values) {
        return this.newArrayWithValue(aClass, (Object)values);
    }

    @Override
    public final ArrayValue newArrayWithValue(ArrayClass aClass, Parameterized[][][] values) {
        return this.newArrayWithValue(aClass, (Object)values);
    }

    @Override
    public final ArrayValue newArrayWithValue(ArrayClass aClass, Parameterized[][][][] values) {
        return this.newArrayWithValue(aClass, (Object)values);
    }

    @Override
    public final ArrayLoader arrayLoad(IVariable arrayReference, Parameterized pardim, Parameterized ... parDims) {
        return OperatorFactory.newOperator(ArrayLoader.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, pardim, parDims);
    }

    @Override
    public final ArrayLoader arrayLoad(MethodInvoker arrayReference, Parameterized pardim, Parameterized ... parDims) {
        return OperatorFactory.newOperator(ArrayLoader.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, pardim, parDims);
    }

    @Override
    public ArrayLoader arrayLoad(ArrayLoader arrayReference, Parameterized pardim, Parameterized ... parDims) {
        return OperatorFactory.newOperator(ArrayLoader.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, pardim, parDims);
    }

    @Override
    public ArrayLoader arrayLoad(ArrayValue arrayReference, Parameterized pardim, Parameterized ... parDims) {
        return OperatorFactory.newOperator(ArrayLoader.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, pardim, parDims);
    }

    @Override
    public ArrayLoader arrayLoad(Assigner arrayReference, Parameterized pardim, Parameterized ... parDims) {
        return OperatorFactory.newOperator(ArrayLoader.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, pardim, parDims);
    }

    @Override
    public final ArrayStorer arrayStore(IVariable arrayReference, Parameterized value, Parameterized dim, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayStorer.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, value, dim, dims);
    }

    @Override
    public final ArrayStorer arrayStore(MethodInvoker arrayReference, Parameterized value, Parameterized dim, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayStorer.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, value, dim, dims);
    }

    @Override
    public ArrayStorer arrayStore(ArrayLoader arrayReference, Parameterized value, Parameterized dim, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayStorer.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, value, dim, dims);
    }

    @Override
    public ArrayStorer arrayStore(ArrayValue arrayReference, Parameterized value, Parameterized dim, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayStorer.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, value, dim, dims);
    }

    @Override
    public ArrayStorer arrayStore(Assigner arrayReference, Parameterized value, Parameterized dim, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayStorer.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, value, dim, dims);
    }

    @Override
    public final ArrayLength arrayLength(IVariable arrayReference, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayLength.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, dims);
    }

    @Override
    public ArrayLength arrayLength(MethodInvoker arrayReference, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayLength.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, dims);
    }

    @Override
    public ArrayLength arrayLength(ArrayLoader arrayReference, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayLength.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, dims);
    }

    @Override
    public ArrayLength arrayLength(ArrayValue arrayReference, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayLength.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, dims);
    }

    @Override
    public ArrayLength arrayLength(Assigner arrayReference, Parameterized ... dims) {
        return OperatorFactory.newOperator(ArrayLength.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), arrayReference, dims);
    }

    @Override
    public final CheckCast checkCast(Parameterized cc, AClass to) {
        if (to.isPrimitive()) {
            throw new IllegalArgumentException("cannot cache cast to type : " + to);
        }
        return OperatorFactory.newOperator(CheckCast.class, new Class[]{ProgramBlock.class, Parameterized.class, AClass.class}, this.getExecuteBlock(), cc, to);
    }

    @Override
    public final Addition add(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(Addition.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final Subtraction sub(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(Subtraction.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final Multiplication mul(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(Multiplication.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final Division div(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(Division.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final Modulus mod(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(Modulus.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final Negative neg(Parameterized factor) {
        return OperatorFactory.newOperator(Negative.class, new Class[]{ProgramBlock.class, Parameterized.class}, this.getExecuteBlock(), factor);
    }

    @Override
    public final Inverts inverts(Parameterized factor) {
        return OperatorFactory.newOperator(Inverts.class, new Class[]{ProgramBlock.class, Parameterized.class}, this.getExecuteBlock(), factor);
    }

    @Override
    public final BitAnd bitAnd(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(BitAnd.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final BitOr bitOr(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(BitOr.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final BitXor bitXor(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(BitXor.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final LeftShift leftShift(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(LeftShift.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final RightShift rightShift(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(RightShift.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final UnsignedRightShift unsignedRightShift(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(UnsignedRightShift.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final BeforeDecrement beforeDec(Crementable crement) {
        return OperatorFactory.newOperator(BeforeDecrement.class, new Class[]{ProgramBlock.class, Crementable.class}, this.getExecuteBlock(), crement);
    }

    @Override
    public final AfterDecrement afterDec(Crementable crement) {
        return OperatorFactory.newOperator(AfterDecrement.class, new Class[]{ProgramBlock.class, Crementable.class}, this.getExecuteBlock(), crement);
    }

    @Override
    public final BeforeIncrement beforeInc(Crementable crement) {
        return OperatorFactory.newOperator(BeforeIncrement.class, new Class[]{ProgramBlock.class, Crementable.class}, this.getExecuteBlock(), crement);
    }

    @Override
    public final AfterIncrement afterInc(Crementable crement) {
        return OperatorFactory.newOperator(AfterIncrement.class, new Class[]{ProgramBlock.class, Crementable.class}, this.getExecuteBlock(), crement);
    }

    @Override
    public final GreaterThan greaterThan(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(GreaterThan.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final GreaterEqual greaterEqual(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(GreaterEqual.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final LessThan lessThan(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(LessThan.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final LessEqual lessEqual(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(LessEqual.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final Equal equal(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(Equal.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final NotEqual notEqual(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(NotEqual.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final LogicalAnd logicalAnd(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(LogicalAnd.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final LogicalOr logicalOr(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(LogicalOr.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final LogicalXor logicalXor(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(LogicalXor.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final ShortCircuitAnd conditionalAnd(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(ShortCircuitAnd.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final ShortCircuitOr conditionalOr(Parameterized factor1, Parameterized factor2) {
        return OperatorFactory.newOperator(ShortCircuitOr.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), factor1, factor2);
    }

    @Override
    public final Not not(Parameterized factor) {
        return OperatorFactory.newOperator(Not.class, new Class[]{ProgramBlock.class, Parameterized.class}, this.getExecuteBlock(), factor);
    }

    @Override
    public final TernaryOperator ternary(Parameterized exp1, Parameterized exp2, Parameterized exp3) {
        return OperatorFactory.newOperator(TernaryOperator.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized.class, Parameterized.class}, this.getExecuteBlock(), exp1, exp2, exp3);
    }

    @Override
    public final Parameterized append(Parameterized par1, Parameterized ... pars) {
        return OperatorFactory.newOperator(StringAppender.class, new Class[]{ProgramBlock.class, Parameterized.class, Parameterized[].class}, this.getExecuteBlock(), par1, pars);
    }

    @Override
    public final Parameterized instanceOf(Parameterized obj, AClass type) {
        return OperatorFactory.newOperator(InstanceofOperator.class, new Class[]{ProgramBlock.class, Parameterized.class, AClass.class}, this.getExecuteBlock(), obj, type);
    }

    @Override
    public final MethodInvoker invoke(Parameterized caller, String methodName, Parameterized ... arguments) {
        return OperatorFactory.newOperator(CommonMethodInvoker.class, new Class[]{ProgramBlock.class, Parameterized.class, String.class, Parameterized[].class}, this.getExecuteBlock(), caller, methodName, arguments);
    }

    protected final void invokeVerify(AClass a) {
        if (a.isInterface()) {
            throw new MethodInvokeException("the class " + this.getExecuteBlock().getMethodOwner() + " is a interface and interfaces have no static methods");
        }
        if (a.isPrimitive()) {
            throw new MethodInvokeException("the class " + this.getExecuteBlock().getMethodOwner() + " is a primitive and primitive cannot as a method invoker owner");
        }
    }

    @Override
    public final MethodInvoker invokeStatic(AClass owner, String methodName, Parameterized ... arguments) {
        this.invokeVerify(owner);
        return OperatorFactory.newOperator(StaticMethodInvoker.class, new Class[]{ProgramBlock.class, AClass.class, String.class, Parameterized[].class}, this.getExecuteBlock(), owner, methodName, arguments);
    }

    @Override
    public final MethodInvoker invokeConstructor(AClass owner, Parameterized ... arguments) {
        this.invokeVerify(owner);
        return OperatorFactory.newOperator(ConstructorInvoker.class, new Class[]{ProgramBlock.class, AClass.class, Parameterized[].class}, this.getExecuteBlock(), owner, arguments);
    }

    @Override
    public final IF ifthan(IF ifs) {
        this.addExe(ifs);
        ifs.setParentExes(this.getExecuteQueue());
        ifs.setParentPreExes(this.getPreExecuteInsn());
        this.subBlockPrepare(ifs);
        return ifs;
    }

    @Override
    public final WhileLoop whileloop(WhileLoop wl) {
        this.addExe(wl);
        this.subBlockPrepare(wl);
        return wl;
    }

    @Override
    public final WhileLoop dowhile(DoWhileLoop dwl) {
        this.addExe(dwl);
        this.subBlockPrepare(dwl);
        return dwl;
    }

    @Override
    public final ForEachLoop forEach(ForEachLoop forEach) {
        this.addExe(forEach);
        this.subBlockPrepare(forEach);
        return forEach;
    }

    @Override
    public final void breakout() {
        ProgramBlock pb = this.getExecuteBlock();
        while (pb != null) {
            if (pb instanceof ILoop) {
                new GOTO(this.getExecuteBlock(), ((ILoop)((Object)pb)).getBreakLabel());
                return;
            }
            pb = pb.ownerBlock;
        }
        throw new InternalError("there is on loop!");
    }

    @Override
    public final void continueout() {
        ProgramBlock pb = this.getExecuteBlock();
        while (pb != null) {
            if (pb instanceof ILoop) {
                new GOTO(this.getExecuteBlock(), ((ILoop)((Object)pb)).getContinueLabel());
                return;
            }
            pb = pb.ownerBlock;
        }
        throw new InternalError("there is on loop!");
    }

    @Override
    public final void throwException(Parameterized exception) {
        OperatorFactory.newOperator(Throw.class, new Class[]{ProgramBlock.class, Parameterized.class}, this.getExecuteBlock(), exception);
    }

    @Override
    public final Try tryDo(Try t) {
        t.setParentExes(this.getExecuteQueue());
        t.setParentPreExes(this.getPreExecuteInsn());
        this.addExe(t);
        this.subBlockPrepare(t);
        return t;
    }

    @Override
    public final Synchronized syn(Synchronized s) {
        this.addExe(s);
        this.subBlockPrepare(s);
        return s;
    }

    @Override
    public final ThisVariable getThis() {
        if (this.getMethod().isStatic()) {
            throw new ASMSupportException("cannnot use \"this\" keyword in static block");
        }
        return this.method.getMethodOwner().getThisVariable();
    }

    @Override
    public final SuperVariable getSuper() {
        if (this.getMethod().isStatic()) {
            throw new ASMSupportException("cannnot use \"this\" keyword in statc block");
        }
        return this.method.getMethodOwner().getSuperVariable();
    }

    @Override
    public final MethodInvoker invokeOriginalMethod() {
        if (this.getMethod().getMode() == 1) {
            String originalMethodName = this.getMethod().getMethodEntity().getName();
            if (originalMethodName.equals("<clinit>")) {
                originalMethodName = "&clinit&";
            } else if (originalMethodName.equals("<init>")) {
                originalMethodName = "&init&";
            }
            String methodNameByProxy = originalMethodName + "@ByProxy";
            if (this.getMethod().isStatic()) {
                return this.invokeStatic(this.getMethod().getMethodOwner(), methodNameByProxy, this.getMethodArguments());
            }
            return this.invoke(this.getThis(), methodNameByProxy, this.getMethodArguments());
        }
        throw new ASMSupportException("this method is new and not modify!");
    }

    @Override
    public final Return runReturn() {
        if (!this.method.getMethodEntity().getReturnType().equals((Object)Type.VOID_TYPE)) {
            throw new VerifyErrorException("Do not specify a return type! ");
        }
        return OperatorFactory.newOperator(Return.class, new Class[]{ProgramBlock.class, Parameterized.class}, this.getExecuteBlock(), null);
    }

    @Override
    public final Return runReturn(Parameterized parame) {
        return OperatorFactory.newOperator(Return.class, new Class[]{ProgramBlock.class, Parameterized.class}, this.getExecuteBlock(), parame);
    }
}

