/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.block.control;

import java.util.List;
import jw.asmsupport.Executeable;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.block.control.Finally;
import jw.asmsupport.block.control.SeriesBlock;
import jw.asmsupport.block.control.Try;
import jw.asmsupport.block.method.SuperMethodBody;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.definition.variable.LocalVariable;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.exception.UnreachableCode;
import jw.asmsupport.operators.NoneOperator;
import jw.asmsupport.operators.Throw;
import jw.asmsupport.operators.asmdirect.GOTO;
import jw.asmsupport.operators.asmdirect.Marker;
import jw.asmsupport.operators.asmdirect.NOP;
import jw.asmsupport.operators.asmdirect.Store;
import jw.asmsupport.operators.util.OperatorFactory;
import jw.asmsupport.utils.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Label;

public abstract class Catch
extends SeriesBlock {
    private static Log log = LogFactory.getLog(Catch.class);
    private AClass exception;
    private Try entityTry;
    private Catch nextCatch;
    private Finally finallyBlock;
    private Label catchLbl;
    private Label endCatchLbl1;
    private Label endCatchLbl2;
    private Label implicitCatchStartLbl;
    private Store implicitCatchThrowableStore;
    private List<Executeable> parentExes;
    private List<Executeable> parentPreExes;

    public Catch(AClass exception) {
        this.exception = exception;
        this.catchLbl = new Label();
        this.endCatchLbl1 = new Label();
        this.endCatchLbl2 = new Label();
        this.implicitCatchStartLbl = new Label();
    }

    void setFinallyBlock(Finally finallyBlock) {
        this.finallyBlock = finallyBlock;
    }

    public Finally getFinallyBlock() {
        return this.finallyBlock;
    }

    @Override
    public void executing() {
        this.insnHelper.mark(this.catchLbl);
        Stack stack = this.insnHelper.getMv().getStack();
        stack.push(this.exception.getType());
        this.insnHelper.nop();
        for (Executeable exe : this.getExecuteQueue()) {
            if (exe.equals(this.implicitCatchThrowableStore)) {
                stack.push(AClass.THROWABLE_ACLASS.getType());
            }
            exe.execute();
        }
        if (this.finallyBlock == null) {
            this.insnHelper.mark(this.endCatchLbl2);
        }
    }

    @Override
    protected void init() {
        SuperMethodBody mb = this.getMethodBody();
        mb.addTryCatchInfo(this.entityTry.getStart(), this.entityTry.getEnd(), this.catchLbl, this.exception);
        if (this.finallyBlock != null) {
            mb.addTryCatchInfo(this.entityTry.getStart(), this.entityTry.getEnd(), this.implicitCatchStartLbl, null);
            for (Catch nextCatch = this.entityTry.getCatchEntity(); nextCatch != null; nextCatch = nextCatch.getNextCatch()) {
                mb.addTryCatchInfo(nextCatch.catchLbl, this.endCatchLbl1, this.implicitCatchStartLbl, null);
            }
        }
    }

    @Override
    public final void generateInsn() {
        Label exceptionLbl = new Label();
        LocalVariable lv = this.getLocalVariableModel("e", this.exception);
        new Store(this.getExecuteBlock(), lv);
        lv.getScopeLogicVar().setSpecifiedStartLabel(exceptionLbl);
        new Marker(this.getExecuteBlock(), exceptionLbl);
        this.catchBody(lv);
        new Marker(this.getExecuteBlock(), this.endCatchLbl1);
        new NOP(this.getExecuteBlock());
        Finally finallyOfCurrentTrySeries = this.getFinally();
        if (finallyOfCurrentTrySeries != null) {
            new Marker(this.getExecuteBlock(), this.endCatchLbl2);
            try {
                OperatorFactory.newOperator(NoneOperator.class, new Class[]{ProgramBlock.class}, this.getExecuteBlock());
                this.finallyBlock.clonerGenerate(this.getExecuteBlock());
            }
            catch (UnreachableCode uc) {
                log.info((Object)uc.getMessage());
            }
            catch (RuntimeException e) {
                throw e;
            }
        }
        try {
            OperatorFactory.newOperator(NoneOperator.class, new Class[]{ProgramBlock.class}, this.getExecuteBlock());
            new GOTO(this.getExecuteBlock(), this.getTerminalEndLabelInCatch());
        }
        catch (UnreachableCode uc) {
            log.info((Object)"unreachable code");
        }
        catch (RuntimeException e) {
            throw e;
        }
        Finally finallyOfCurrentCatch = this.finallyBlock;
        if (finallyOfCurrentCatch != null) {
            this.generateThrowableCatch();
        }
    }

    public abstract void catchBody(LocalVariable var1);

    private void generateThrowableCatch() {
        boolean currentCheckUnrechableCode = this.getExecuteBlock().whetherCheckUnreachableCode();
        this.getExecuteBlock().setWhetherCheckUnreachableCode(false);
        new Marker(this.getExecuteBlock(), this.implicitCatchStartLbl);
        LocalVariable exception = this.getLocalAnonymousVariableModel(AClass.THROWABLE_ACLASS);
        this.implicitCatchThrowableStore = new Store(this.getExecuteBlock(), exception);
        this.finallyBlock.clonerGenerate(this.getExecuteBlock());
        OperatorFactory.newOperator(Throw.class, new Class[]{ProgramBlock.class, Parameterized.class, Boolean.TYPE}, this.getExecuteBlock(), exception, true);
        this.getExecuteBlock().setWhetherCheckUnreachableCode(currentCheckUnrechableCode);
    }

    void setEntityTry(Try t) {
        this.entityTry = t;
    }

    public boolean checkCatch(AClass excep) {
        if (excep.isChildOrEqual(this.exception)) {
            return true;
        }
        if (this.nextCatch != null) {
            return this.nextCatch.checkCatch(excep);
        }
        return false;
    }

    public Catch catchException(Catch ca) {
        if (this.finallyBlock != null) {
            throw new ASMSupportException("cannot declare catch after finally block");
        }
        if (this.entityTry.checkCatchBlockException(ca.exception)) {
            throw new ASMSupportException("the exception type " + ca.exception + " has been catch by previously catch block");
        }
        this.entityTry.addCatchedException(ca.getException());
        this.nextCatch = ca;
        this.parentExes.add(ca);
        this.parentPreExes.add(ca);
        ca.setParentExes(this.parentExes);
        ca.setParentPreExes(this.parentPreExes);
        ca.setEntityTry(this.entityTry);
        ca.setPrevious(this);
        this.subBlockPrepare(ca, this.getOwnerBlock());
        return ca;
    }

    public Finally finallyThan(Finally fly) {
        if (this.nextCatch != null) {
            throw new ASMSupportException("cannot declare finally block before catch");
        }
        this.setFinallyBlock(fly);
        fly.setPrevious(this);
        this.subBlockPrepare(fly, this.getOwnerBlock());
        this.parentExes.add(fly);
        this.parentPreExes.add(fly);
        return fly;
    }

    @Override
    public void setReturned(boolean returned) {
        super.setReturned(returned);
        boolean superReturned = true;
        for (SeriesBlock previous = this.getPrevious(); previous != null; previous = previous.getPrevious()) {
            if (previous.isReturned()) continue;
            superReturned = false;
            break;
        }
        if (superReturned) {
            this.getOwnerBlock().setReturned(returned);
        }
    }

    public Finally getFinally() {
        if (this.finallyBlock != null) {
            return this.finallyBlock;
        }
        if (this.nextCatch != null) {
            return this.nextCatch.getFinally();
        }
        return null;
    }

    public void setParentExes(List<Executeable> parentExes) {
        this.parentExes = parentExes;
    }

    public void setParentPreExes(List<Executeable> parentPreExes) {
        this.parentPreExes = parentPreExes;
    }

    private Label getTerminalEndLabelInCatch() {
        if (this.nextCatch == null) {
            if (this.finallyBlock != null) {
                return this.finallyBlock.endLbl;
            }
            return this.endCatchLbl2;
        }
        return this.nextCatch.getTerminalEndLabelInCatch();
    }

    Label getTerminalEndLabel() {
        if (this.nextCatch == null) {
            if (this.finallyBlock != null) {
                return this.finallyBlock.startLbl;
            }
            return this.endCatchLbl2;
        }
        return this.nextCatch.getTerminalEndLabel();
    }

    public Catch getNextCatch() {
        return this.nextCatch;
    }

    public AClass getException() {
        return this.exception;
    }

    public String toString() {
        return "Catch Block:" + super.toString();
    }
}

