/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.block.control;

import java.util.List;
import jw.asmsupport.Executeable;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.control.ControlBlock;
import jw.asmsupport.block.control.ControlType;
import jw.asmsupport.block.control.Else;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.Jumpable;
import org.objectweb.asm.Label;

public abstract class ElseIF
extends ControlBlock {
    private Parameterized condition;
    private ControlBlock elseifOrIfBlock;
    private List<Executeable> parentExes;
    private List<Executeable> parentPreExes;

    public ElseIF(Parameterized condition) {
        this.condition = condition;
        condition.asArgument();
    }

    @Override
    public void executing() {
        this.insnHelper.nop();
        if (this.condition instanceof Jumpable) {
            Jumpable jmp = (Jumpable)this.condition;
            jmp.setJumpLable(this.getEndLabel());
            jmp.executeAndJump(ControlType.IF);
        } else {
            this.condition.loadToStack(this);
            this.insnHelper.unbox(this.condition.getParamterizedType().getType());
            this.insnHelper.ifZCmp(153, this.getEndLabel());
        }
        this.insnHelper.nop();
        for (Executeable exe : this.getExecuteQueue()) {
            exe.execute();
        }
        if (this.elseifOrIfBlock != null) {
            this.insnHelper.goTo(this.getLastLabel());
        }
        this.insnHelper.mark(this.getEndLabel());
    }

    @Override
    protected void init() {
        if (!this.condition.getParamterizedType().equals(AClass.BOOLEAN_WRAP_ACLASS) && !this.condition.getParamterizedType().equals(AClass.BOOLEAN_ACLASS)) {
            throw new ASMSupportException("the condition type of if statement must be boolean or Boolean, but was " + this.condition.getParamterizedType());
        }
    }

    public void elsethan(Else elseblock) {
        this.elseifOrIfBlock = elseblock;
        this.parentExes.add(elseblock);
        this.parentPreExes.add(elseblock);
        this.subBlockPrepare(elseblock, this.getOwnerBlock());
        elseblock.setPrevious(this);
    }

    public ElseIF elseif(ElseIF elseblock) {
        elseblock.setParentExes(this.parentExes);
        elseblock.setParentPreExes(this.parentPreExes);
        this.parentExes.add(elseblock);
        this.parentPreExes.add(elseblock);
        this.subBlockPrepare(elseblock, this.getOwnerBlock());
        elseblock.setPrevious(this);
        this.elseifOrIfBlock = elseblock;
        return elseblock;
    }

    @Override
    Label getLastLabel() {
        if (this.elseifOrIfBlock == null) {
            return this.getEndLabel();
        }
        return this.elseifOrIfBlock.getLastLabel();
    }

    public void setParentExes(List<Executeable> parentExes) {
        this.parentExes = parentExes;
    }

    public void setParentPreExes(List<Executeable> parentPreExes) {
        this.parentPreExes = parentPreExes;
    }
}

