/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.block.control;

import jw.asmsupport.Executeable;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.block.control.ControlType;
import jw.asmsupport.block.control.ILoop;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.definition.value.Value;
import jw.asmsupport.definition.variable.LocalVariable;
import jw.asmsupport.definition.variable.MemberVariable;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.Jumpable;
import jw.asmsupport.operators.asmdirect.GOTO;
import jw.asmsupport.operators.asmdirect.Marker;
import jw.asmsupport.operators.asmdirect.NOP;
import org.objectweb.asm.Label;

public abstract class ForEachLoop
extends ProgramBlock
implements ILoop {
    private MemberVariable member;
    private Parameterized condition;
    private Label startLbl = new Label();
    private Label conditionLbl = new Label();
    private Label continueLbl = new Label();
    private Label endLbl = new Label();

    public ForEachLoop(MemberVariable member) {
        this.member = member;
        this.checkMember(member);
    }

    private void checkMember(MemberVariable member) {
        AClass cls = member.getParamterizedType();
        if (!cls.isArray() && !cls.isChildOrEqual(AClassFactory.getProductClass(Iterable.class))) {
            throw new ASMSupportException("The object must be an array or an object that implements the new Iterable interface.");
        }
    }

    @Override
    public void executing() {
        for (Executeable exe : this.getExecuteQueue()) {
            exe.execute();
        }
        if (this.condition instanceof Jumpable) {
            Jumpable jmp = (Jumpable)this.condition;
            jmp.setJumpLable(this.startLbl);
            jmp.executeAndJump(ControlType.WHILE);
        } else {
            this.condition.loadToStack(this);
            this.insnHelper.unbox(this.condition.getParamterizedType().getType());
            this.insnHelper.ifZCmp(154, this.startLbl);
        }
        this.insnHelper.mark(this.endLbl);
    }

    @Override
    protected void init() {
    }

    @Override
    public final void generateInsn() {
        new NOP(this.getExecuteBlock());
        if (this.member.getParamterizedType().isArray()) {
            LocalVariable i = this.createVariable(null, AClass.INT_ACLASS, true, Value.value(0));
            new GOTO(this.getExecuteBlock(), this.conditionLbl);
            new NOP(this.getExecuteBlock());
            new Marker(this.getExecuteBlock(), this.startLbl);
            new NOP(this.getExecuteBlock());
            LocalVariable obj = this.createVariable(null, ((ArrayClass)this.member.getParamterizedType()).getNextDimType(), true, this.arrayLoad(this.member, (Parameterized)i, new Parameterized[0]));
            this.generateBody(obj);
            new Marker(this.getExecuteBlock(), this.continueLbl);
            this.afterInc(i);
            new Marker(this.getExecuteBlock(), this.conditionLbl);
            this.condition = this.lessThan(i, this.arrayLength(this.member, new Parameterized[0]));
        } else {
            LocalVariable itr = this.createVariable(null, AClass.ITERATOR_ACLASS, true, this.invoke(this.member, "iterator", new Parameterized[0]));
            new GOTO(this.getExecuteBlock(), this.conditionLbl);
            new Marker(this.getExecuteBlock(), this.startLbl);
            new NOP(this.getExecuteBlock());
            LocalVariable obj = this.createVariable(null, AClass.OBJECT_ACLASS, true, this.invoke(itr, "next", new Parameterized[0]));
            this.generateBody(obj);
            new Marker(this.getExecuteBlock(), this.continueLbl);
            new Marker(this.getExecuteBlock(), this.conditionLbl);
            this.condition = this.invoke(itr, "hasNext", new Parameterized[0]);
        }
        this.condition.asArgument();
    }

    public abstract void generateBody(LocalVariable var1);

    @Override
    public Label getBreakLabel() {
        return this.endLbl;
    }

    @Override
    public Label getContinueLabel() {
        return this.continueLbl;
    }

    public String toString() {
        return "For Each Block:" + super.toString();
    }
}

