/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.block.control;

import java.util.List;
import jw.asmsupport.Executeable;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.control.ControlBlock;
import jw.asmsupport.block.control.ControlType;
import jw.asmsupport.block.control.Else;
import jw.asmsupport.block.control.ElseIF;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.Jumpable;
import org.objectweb.asm.Label;

public abstract class IF
extends ControlBlock {
    private Parameterized condition;
    private ControlBlock elseOrElseIFBlock;
    private List<Executeable> parentExes;
    private List<Executeable> parentPreExes;

    public IF(Parameterized condition) {
        condition.asArgument();
        this.condition = condition;
    }

    @Override
    public void executing() {
        this.insnHelper.nop();
        if (this.condition instanceof Jumpable) {
            Jumpable jmp = (Jumpable)this.condition;
            jmp.setJumpLable(this.getEndLabel());
            jmp.executeAndJump(ControlType.IF);
        } else {
            this.condition.loadToStack(this);
            this.insnHelper.unbox(this.condition.getParamterizedType().getType());
            this.insnHelper.ifZCmp(153, this.getEndLabel());
        }
        this.insnHelper.nop();
        for (Executeable exe : this.getExecuteQueue()) {
            exe.execute();
        }
        if (this.elseOrElseIFBlock != null) {
            this.insnHelper.goTo(this.getLastLabel());
        }
        this.insnHelper.mark(this.getEndLabel());
    }

    @Override
    protected void init() {
        if (!this.condition.getParamterizedType().equals(AClass.BOOLEAN_WRAP_ACLASS) && !this.condition.getParamterizedType().equals(AClass.BOOLEAN_ACLASS)) {
            throw new ASMSupportException("the condition type of if statement must be boolean or Boolean, but was " + this.condition.getParamterizedType());
        }
    }

    @Override
    Label getLastLabel() {
        if (this.elseOrElseIFBlock == null) {
            return this.getEndLabel();
        }
        return this.elseOrElseIFBlock.getLastLabel();
    }

    public void elsethan(Else elseblock) {
        this.parentExes.add(elseblock);
        this.parentPreExes.add(elseblock);
        this.elseOrElseIFBlock = elseblock;
        this.subBlockPrepare(elseblock, this.getOwnerBlock());
        elseblock.setPrevious(this);
    }

    public ElseIF elseif(ElseIF elseIfBlock) {
        elseIfBlock.setParentExes(this.parentExes);
        elseIfBlock.setParentPreExes(this.parentPreExes);
        this.parentExes.add(elseIfBlock);
        this.parentPreExes.add(elseIfBlock);
        this.subBlockPrepare(elseIfBlock, this.getOwnerBlock());
        elseIfBlock.setPrevious(this);
        this.elseOrElseIFBlock = elseIfBlock;
        return elseIfBlock;
    }

    public void setParentExes(List<Executeable> parentExes) {
        this.parentExes = parentExes;
    }

    public void setParentPreExes(List<Executeable> parentPreExes) {
        this.parentPreExes = parentPreExes;
    }

    public String toString() {
        return "IF Block:" + super.toString();
    }
}

