/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.block.control;

import java.util.List;
import jw.asmsupport.Executeable;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.block.control.Catch;
import jw.asmsupport.block.control.Finally;
import jw.asmsupport.block.control.SeriesBlock;
import jw.asmsupport.block.method.SuperMethodBody;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.definition.variable.LocalVariable;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.exception.UnreachableCode;
import jw.asmsupport.operators.NoneOperator;
import jw.asmsupport.operators.Throw;
import jw.asmsupport.operators.asmdirect.GOTO;
import jw.asmsupport.operators.asmdirect.Marker;
import jw.asmsupport.operators.asmdirect.Store;
import jw.asmsupport.operators.util.OperatorFactory;
import jw.asmsupport.operators.util.ThrowExceptionContainer;
import jw.asmsupport.utils.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Label;

public abstract class Try
extends SeriesBlock {
    private static Log log = LogFactory.getLog(Try.class);
    private Catch catchEntity;
    private Label start = new Label();
    private Label end = new Label();
    private ThrowExceptionContainer catchedExceptions;
    private List<Executeable> parentExes;
    private List<Executeable> parentPreExes;
    private Finally finallyBlock;
    private Label implicitCatchStartLbl = new Label();
    private Store implicitCatchThrowableStore;

    public Try() {
        this.catchedExceptions = new ThrowExceptionContainer();
    }

    public void addCatchedException(AClass exception) {
        this.catchedExceptions.add(exception);
        this.removeException(exception);
    }

    @Override
    public void addException(AClass exception) {
        if (!this.catchedExceptions.contains(exception)) {
            super.addException(exception);
        }
    }

    public abstract void generateBody();

    @Override
    public final void generateInsn() {
        this.generateBody();
        boolean returnInTry = false;
        try {
            OperatorFactory.newOperator(NoneOperator.class, new Class[]{ProgramBlock.class}, this.getExecuteBlock());
            new GOTO(this.getExecuteBlock(), this.getTerminalEndLabel());
        }
        catch (UnreachableCode uc) {
            log.info((Object)"unreachable code");
            returnInTry = true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        if (this.finallyBlock != null) {
            this.generateThrowableCatch();
            if (returnInTry) {
                this.finallyBlock.getOwnerBlock().removeExe(this.finallyBlock);
            }
        }
    }

    @Override
    public void executing() {
        this.insnHelper.nop();
        this.insnHelper.mark(this.start);
        this.insnHelper.nop();
        Stack stack = this.insnHelper.getMv().getStack();
        for (Executeable exe : this.getExecuteQueue()) {
            if (exe.equals(this.implicitCatchThrowableStore)) {
                this.insnHelper.mark(this.end);
                stack.push(AClass.THROWABLE_ACLASS.getType());
            }
            exe.execute();
        }
        try {
            this.end.getOffset();
        }
        catch (IllegalStateException e) {
            this.insnHelper.mark(this.end);
        }
    }

    @Override
    protected void init() {
        SuperMethodBody mb = this.getMethodBody();
        if (this.finallyBlock != null) {
            mb.addTryCatchInfo(this.getStart(), this.getEnd(), this.implicitCatchStartLbl, null);
        }
    }

    public boolean checkCatchBlockException(AClass exception) {
        return this.catchEntity.checkCatch(exception);
    }

    public Catch catchException(Catch ca) {
        if (this.finallyBlock != null) {
            throw new ASMSupportException("exist finally block. please create catch before finally block");
        }
        this.catchEntity = ca;
        ca.setEntityTry(this);
        this.parentExes.add(ca);
        this.parentPreExes.add(ca);
        ca.setParentExes(this.parentExes);
        ca.setParentPreExes(this.parentPreExes);
        ca.setPrevious(this);
        this.addCatchedException(ca.getException());
        this.subBlockPrepare(ca, this.getOwnerBlock());
        return ca;
    }

    public Finally finallyThan(Finally fny) {
        if (this.catchEntity != null) {
            throw new ASMSupportException("has been catch exception. please create finally block by Catch");
        }
        this.setFinallyBlock(fny);
        fny.setPrevious(this);
        this.subBlockPrepare(fny, this.getOwnerBlock());
        this.parentExes.add(fny);
        this.parentPreExes.add(fny);
        return fny;
    }

    public void setParentExes(List<Executeable> parentExes) {
        this.parentExes = parentExes;
    }

    public void setParentPreExes(List<Executeable> parentPreExes) {
        this.parentPreExes = parentPreExes;
    }

    public void setFinallyBlock(Finally finallyBlock) {
        this.finallyBlock = finallyBlock;
    }

    public Finally getFinallyBlock() {
        if (this.finallyBlock != null) {
            return this.finallyBlock;
        }
        if (this.catchEntity != null) {
            return this.catchEntity.getFinally();
        }
        return null;
    }

    public Catch getCatchEntity() {
        return this.catchEntity;
    }

    Label getTerminalEndLabel() {
        if (this.catchEntity != null) {
            return this.catchEntity.getTerminalEndLabel();
        }
        if (this.finallyBlock != null) {
            return this.finallyBlock.startLbl;
        }
        throw new ASMSupportException("insert \"Finally\"  or \"Catch\" to complete TryStatement");
    }

    private void generateThrowableCatch() {
        boolean currentCheckUnrechableCode = this.getExecuteBlock().whetherCheckUnreachableCode();
        this.getExecuteBlock().setWhetherCheckUnreachableCode(false);
        new Marker(this.getExecuteBlock(), this.implicitCatchStartLbl);
        LocalVariable exception = this.getLocalAnonymousVariableModel(AClass.THROWABLE_ACLASS);
        this.implicitCatchThrowableStore = new Store(this.getExecuteBlock(), exception);
        this.finallyBlock.clonerGenerate(this.getExecuteBlock());
        OperatorFactory.newOperator(UnAddExceptionThrow.class, new Class[]{ProgramBlock.class, Parameterized.class}, this.getExecuteBlock(), exception);
        this.getExecuteBlock().setWhetherCheckUnreachableCode(currentCheckUnrechableCode);
    }

    public Label getStart() {
        return this.start;
    }

    public Label getEnd() {
        return this.end;
    }

    public ThrowExceptionContainer getCatchedExceptions() {
        return this.catchedExceptions;
    }

    public String toString() {
        return "Try Block:" + super.toString();
    }

    public static class UnAddExceptionThrow
    extends Throw {
        public UnAddExceptionThrow(ProgramBlock block, Parameterized exception) {
            super(block, exception);
        }

        @Override
        protected void beforeInitProperties() {
        }
    }
}

