/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.block.control;

import jw.asmsupport.Executeable;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.block.control.ControlType;
import jw.asmsupport.block.control.ILoop;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.Jumpable;
import org.objectweb.asm.Label;

public abstract class WhileLoop
extends ProgramBlock
implements ILoop {
    private Parameterized condition;
    Label condiLbl;
    Label startLbl;
    Label end;
    protected boolean isDoWhile;

    public WhileLoop(Parameterized condition) {
        this.condition = condition;
        this.condiLbl = new Label();
        this.startLbl = new Label();
        this.end = new Label();
        condition.asArgument();
    }

    @Override
    public void executing() {
        this.insnHelper.nop();
        if (!this.isDoWhile) {
            this.insnHelper.goTo(this.condiLbl);
        }
        this.insnHelper.mark(this.startLbl);
        this.insnHelper.nop();
        for (Executeable exe : this.getExecuteQueue()) {
            exe.execute();
        }
        this.insnHelper.mark(this.condiLbl);
        if (this.condition instanceof Jumpable) {
            Jumpable jmp = (Jumpable)this.condition;
            jmp.setJumpLable(this.startLbl);
            jmp.executeAndJump(ControlType.WHILE);
        } else {
            this.condition.loadToStack(this);
            this.insnHelper.unbox(this.condition.getParamterizedType().getType());
            this.insnHelper.ifZCmp(154, this.startLbl);
        }
        this.insnHelper.mark(this.end);
    }

    @Override
    protected void init() {
        if (!this.condition.getParamterizedType().equals(AClass.BOOLEAN_WRAP_ACLASS) && !this.condition.getParamterizedType().equals(AClass.BOOLEAN_ACLASS)) {
            throw new ASMSupportException("the condition type of if statement must be boolean or Boolean, but was " + this.condition.getParamterizedType());
        }
    }

    @Override
    public Label getBreakLabel() {
        return this.end;
    }

    @Override
    public Label getContinueLabel() {
        return this.condiLbl;
    }

    public String toString() {
        return "While Block:" + super.toString();
    }
}

