/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.block.method;

import java.util.ArrayList;
import java.util.List;
import jw.asmsupport.Executeable;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.definition.variable.LocalVariable;
import jw.asmsupport.entity.LocalVariableEntity;
import jw.asmsupport.entity.MethodEntity;
import jw.asmsupport.operators.util.OperatorFactory;
import jw.asmsupport.operators.variable.LocalVariableCreator;
import jw.asmsupport.utils.Component;
import jw.asmsupport.utils.Scope;
import jw.asmsupport.utils.ScopeLogicVariable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public abstract class SuperMethodBody
extends ProgramBlock {
    private static Log log = LogFactory.getLog(SuperMethodBody.class);
    private List<TryCatchInfo> tryCatches = new ArrayList<TryCatchInfo>();
    protected LocalVariable[] argments;

    @Override
    public LocalVariable[] getMethodArguments() {
        return this.argments;
    }

    @Override
    public final void generateInsn() {
        this.generateBody();
        this.tiggerTryCatchPrepare();
    }

    public abstract void generateBody();

    @Override
    protected void init() {
        MethodEntity me = this.method.getMethodEntity();
        if (!this.method.isStatic()) {
            OperatorFactory.newOperator(LocalVariableCreator.class, new Class[]{ProgramBlock.class, String.class, Type.class, Type.class}, this.getExecuteBlock(), "this", me.getOwner().getType(), this.method.getMethodEntity().getOwner().getType());
        }
        String[] argNames = me.getArgNames();
        AClass[] argClsses = me.getArgClasses();
        this.argments = new LocalVariable[argNames.length];
        for (int i = 0; i < argNames.length; ++i) {
            ScopeLogicVariable slv = new ScopeLogicVariable(argNames[i], this.scope, argClsses[i].getType(), argClsses[i].getType());
            LocalVariableEntity lve = new LocalVariableEntity(argNames[i], 0, argClsses[i]);
            LocalVariable lv = new LocalVariable(lve);
            lv.setScopeLogicVar(slv);
            this.argments[i] = lv;
        }
        this.method.setArguments(this.argments);
    }

    @Override
    public final void executing() {
        if (log.isDebugEnabled()) {
            StringBuilder str = new StringBuilder("create method: ------------");
            str.append(this.method.getMethodEntity().getMethodString());
            log.debug((Object)str);
        }
        for (TryCatchInfo tci : this.tryCatches) {
            this.insnHelper.tryCatchBlock(tci.start, tci.end, tci.hander, tci.exception);
        }
        if (this.method.getMethodEntity().getName().equals("tryCatch")) {
            log.debug((Object)"");
        }
        for (Executeable exe : this.getExecuteQueue()) {
            exe.execute();
        }
    }

    public void endMethodBody() {
        this.checkNoReturnBlock();
        this.declarationVariable(this.scope);
        int s = this.method.getStack().getMaxSize();
        int l = this.scope.getLocals().getSize();
        this.insnHelper.maxs(s, l);
    }

    private void checkNoReturnBlock() {
    }

    private void declarationVariable(Scope parent) {
        List<Component> coms = parent.getComponents();
        Scope lastBrotherScope = null;
        for (int i = 0; i < coms.size(); ++i) {
            Component com = coms.get(i);
            if (com instanceof ScopeLogicVariable) {
                ScopeLogicVariable slv = (ScopeLogicVariable)com;
                if (slv.isAnonymous()) continue;
                this.insnHelper.declarationVariable(slv.getName(), slv.getDeclareType().getDescriptor(), null, slv.getSpecifiedStartLabel(), parent.innerEnd(), slv.getInitStartPos());
                continue;
            }
            lastBrotherScope = (Scope)com;
            this.declarationVariable(lastBrotherScope);
        }
    }

    public void addTryCatchInfo(Label start, Label end, Label hander, AClass exception) {
        TryCatchInfo tci = new TryCatchInfo();
        tci.start = start;
        tci.end = end;
        tci.hander = hander;
        tci.exception = exception == null ? null : exception.getType();
        this.tryCatches.add(tci);
    }

    private static class TryCatchInfo {
        Label start;
        Label end;
        Label hander;
        Type exception;

        private TryCatchInfo() {
        }
    }
}

