/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.block.method.cinit;

import java.util.ArrayList;
import java.util.List;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.method.SuperMethodBody;
import jw.asmsupport.block.method.cinit.IEnumCInitBody;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.definition.value.Value;
import jw.asmsupport.definition.variable.GlobalVariable;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.array.ArrayValue;
import jw.asmsupport.operators.method.MethodInvoker;
import jw.asmsupport.utils.ModifierUtils;

public abstract class EnumCInitBody
extends SuperMethodBody
implements IEnumCInitBody {
    private List<EnumConstructorInfo> enumArgumentsList;
    protected List<String> enumNameList;

    public void setEnumNameList(List<String> enumNameList) {
        this.enumNameList = enumNameList;
    }

    @Override
    protected void init() {
        this.enumArgumentsList = new ArrayList<EnumConstructorInfo>(3);
    }

    @Override
    public void newEnum(String name, Parameterized ... argus) {
        if (!ModifierUtils.isEnum(this.getMethodOwner().getModifiers())) {
            throw new IllegalArgumentException("cannot create an enum constant cause by current class is not enum type");
        }
        GlobalVariable constant = this.getMethodOwner().getGlobalVariable(name);
        if (!ModifierUtils.isEnum(constant.getGlobalVariableEntity().getModifiers())) {
            throw new IllegalArgumentException("cannot new an enum instant assign to non-enum type variable");
        }
        this.enumArgumentsList.add(new EnumConstructorInfo(name, argus));
    }

    private void constructEachEnumConstant() {
        this.constructEnumField();
        if (this.getMethodOwner().getEnumNum() != this.enumArgumentsList.size()) {
            throw new ASMSupportException("exist unassign enum constant!");
        }
        Parameterized[] values = new Parameterized[this.getMethodOwner().getEnumNum()];
        int i = 0;
        for (EnumConstructorInfo enumArgu : this.enumArgumentsList) {
            GlobalVariable enumConstant = this.getMethodOwner().getGlobalVariable(enumArgu.name);
            values[i] = enumConstant;
            String enumName = enumArgu.name;
            Parameterized[] otherArgus = enumArgu.argus;
            Parameterized[] enumArgus = new Parameterized[otherArgus.length + 2];
            enumArgus[0] = Value.value(enumName);
            enumArgus[1] = Value.value(i);
            System.arraycopy(otherArgus, 0, enumArgus, 2, otherArgus.length);
            MethodInvoker mi = this.invokeConstructor(this.getMethodOwner(), enumArgus);
            this.assign(enumConstant, mi);
            ++i;
        }
        GlobalVariable gv = this.getMethodOwner().getGlobalVariable("ENUM$VALUES");
        ArrayValue av = this.newArrayWithValue(AClassFactory.getArrayClass(this.getMethodOwner(), 1), values);
        this.assign(gv, av);
    }

    @Override
    public void generateBody() {
        this.constructEachEnumConstant();
        this.blockBody();
    }

    public abstract void constructEnumField();

    public abstract void blockBody();

    private class EnumConstructorInfo {
        String name;
        Parameterized[] argus;

        private EnumConstructorInfo(String name, Parameterized[] argus) {
            this.name = name;
            this.argus = argus;
        }
    }
}

