/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.clazz;

import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.clazz.ProductClass;
import jw.asmsupport.clazz.SemiClass;
import jw.asmsupport.exception.ClassException;
import jw.asmsupport.utils.ClassUtils;
import org.objectweb.asm.Type;

public abstract class AClassFactory {
    private static AClass getAndAdd(Class<?> cls) {
        String name = cls.getName();
        AClass aclass = null;
        aclass = cls.isArray() ? AClassFactory.getArrayClass(ClassUtils.getRootComponentType(cls), Type.getType(cls).getDimensions()) : new ProductClass(cls);
        return aclass;
    }

    private static ArrayClass getAndAddForArray(AClass rootComponent, int dim) {
        if (rootComponent.isArray()) {
            throw new ClassException("the class " + rootComponent + " has already a array clss");
        }
        StringBuilder arrayClassDesc = new StringBuilder();
        int tmpDim = dim;
        while (tmpDim-- > 0) {
            arrayClassDesc.append("[");
        }
        arrayClassDesc.append(rootComponent.getDescription());
        return new ArrayClass(rootComponent, dim);
    }

    public static AClass getProductClass(Class<?> cls) {
        return AClassFactory.getAndAdd(cls);
    }

    public static ArrayClass getArrayClass(Class<?> arrayCls) {
        if (!arrayCls.isArray()) {
            throw new ClassException("the class" + arrayCls + " is not a array class");
        }
        return (ArrayClass)AClassFactory.getProductClass(arrayCls);
    }

    public static ArrayClass getArrayClass(Class<?> cls, int dim) {
        return new ArrayClass(AClassFactory.getProductClass(cls), dim);
    }

    public static ArrayClass getArrayClass(AClass cls, int dim) {
        return AClassFactory.getAndAddForArray(cls, dim);
    }

    protected static SemiClass newSemiClass(int version, int access, String name, Class<?> superCls, Class<?>[] interfaces) {
        return new SemiClass(version, access, name, superCls, interfaces);
    }
}

