/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.clazz;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.clazz.NewMemberClass;
import jw.asmsupport.definition.variable.GlobalVariable;
import jw.asmsupport.entity.GlobalVariableEntity;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.utils.ModifierUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class ProductClass
extends NewMemberClass {
    private Class<?> reallyClass;

    protected ProductClass() {
    }

    ProductClass(Class<?> cls) {
        this.name = cls.getName();
        this.mod = cls.getModifiers();
        this.superClass = cls.getSuperclass();
        this.interfaces = cls.getInterfaces();
        this.reallyClass = cls;
        this.type = Type.getType(cls);
    }

    @Override
    public String getDescription() {
        return Type.getDescriptor(this.reallyClass);
    }

    public Class<?> getReallyClass() {
        return this.reallyClass;
    }

    @Override
    public GlobalVariableEntity getGlobalVariableEntity(String name) {
        Class<?> fieldOwner = this.reallyClass;
        GlobalVariableEntity entiey = null;
        while (!fieldOwner.equals(Object.class)) {
            try {
                Field f = fieldOwner.getDeclaredField(name);
                entiey = new GlobalVariableEntity(this, AClassFactory.getProductClass(f.getType()), f.getModifiers(), name);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            fieldOwner = fieldOwner.getSuperclass();
        }
        return entiey;
    }

    @Override
    public GlobalVariable getGlobalVariable(String name) {
        Class<?> fieldOwner;
        GlobalVariable gv = super.getGlobalVariable(name);
        if (gv != null) {
            return gv;
        }
        Field f = null;
        for (fieldOwner = this.reallyClass; fieldOwner != null; fieldOwner = fieldOwner.getSuperclass()) {
            try {
                f = fieldOwner.getDeclaredField(name);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (f == null) {
            throw new ASMSupportException("no such field exception : " + name);
        }
        if (!ModifierUtils.isStatic(f.getModifiers())) {
            throw new ASMSupportException("the field \"" + f.getName() + "\" is non-static, cannot use current method!");
        }
        return new GlobalVariable(fieldOwner.equals(this.reallyClass) ? this : AClassFactory.getProductClass(fieldOwner), AClassFactory.getProductClass(f.getType()), f.getModifiers(), name);
    }

    @Override
    public int getCastOrder() {
        int order = 0;
        order = this.type == Type.BOOLEAN_TYPE || this.name.equals(Boolean.class.getName()) ? 1 : (this.type == Type.BYTE_TYPE || this.name.equals(Byte.class.getName()) ? 2 : (this.type == Type.SHORT_TYPE || this.name.equals(Short.class.getName()) ? 3 : (this.type == Type.CHAR_TYPE || this.name.equals(Character.class.getName()) ? 3 : (this.type == Type.INT_TYPE || this.name.equals(Integer.class.getName()) ? 4 : (this.type == Type.LONG_TYPE || this.name.equals(Long.class.getName()) ? 5 : (this.type == Type.FLOAT_TYPE || this.name.equals(Float.class.getName()) ? 6 : (this.type == Type.DOUBLE_TYPE || this.name.equals(Double.class.getName()) ? 7 : 8)))))));
        return order;
    }

    @Override
    public boolean isPrimitive() {
        return this.reallyClass.isPrimitive();
    }

    @Override
    public boolean isArray() {
        return this.reallyClass.isArray();
    }

    @Override
    public int getDimension() {
        if (!this.reallyClass.isArray()) {
            throw new ASMSupportException("this class is not array");
        }
        return this.type.getDimensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existStaticInitBlock() {
        boolean[] exist;
        block6: {
            if (super.existStaticInitBlock()) {
                return true;
            }
            exist = new boolean[]{false};
            EmptyVisitor cv = new EmptyVisitor(){

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if (name.equals("<clinit>")) {
                        exist[0] = true;
                    }
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
            };
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                URL resource = loader.getResource(this.reallyClass.getName().replace('.', '/') + ".class");
                if (resource == null) break block6;
                InputStream in = resource.openStream();
                try {
                    ClassReader classReader = new ClassReader(in);
                    classReader.accept((ClassVisitor)cv, 2);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return exist[0];
    }
}

