/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.creator;

import java.util.ArrayList;
import java.util.List;
import jw.asmsupport.clazz.NewMemberClass;
import jw.asmsupport.clazz.SemiClass;
import jw.asmsupport.creator.AbstractClassContext;
import jw.asmsupport.creator.IClassContext;
import jw.asmsupport.creator.IGlobalVariableCreator;
import jw.asmsupport.creator.IMethodCreator;
import jw.asmsupport.definition.method.Method;
import jw.asmsupport.exception.ClassException;
import jw.asmsupport.utils.ClassFileUtils;
import jw.asmsupport.utils.MethodUtils;
import jw.asmsupport.utils.ModifierUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public abstract class AbstractClassCreatorContext
extends AbstractClassContext {
    private static Log LOG = LogFactory.getLog(AbstractClassCreatorContext.class);
    protected SemiClass sc;
    protected boolean haveInitMethod;

    public AbstractClassCreatorContext(int version, int access, String name, Class<?> superCls, Class<?>[] interfaces) {
        if (superCls == null) {
            superCls = Object.class;
        } else if (superCls.isInterface()) {
            throw new ClassException("the super class \"" + superCls.getName() + "\" is an interface");
        }
        this.sc = AbstractClassCreatorContext.newSemiClass(version, access, name, superCls, interfaces);
        this.cw = new ClassWriter(0);
        this.methodCreaters = new ArrayList();
        this.fieldCreators = new ArrayList();
    }

    @Override
    public NewMemberClass getCurrentClass() {
        return this.sc;
    }

    @Override
    public Class<?> startup() {
        String[] interfaceStrs = this.sc.getInterfaces() == null ? new String[]{} : new String[this.sc.getInterfaces().length];
        for (int i = 0; i < interfaceStrs.length; ++i) {
            interfaceStrs[i] = Type.getInternalName(this.sc.getInterfaces()[i]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting create class : " + this.sc.getName()));
        }
        this.cw.visit(this.sc.getVersion(), this.sc.getModifiers(), this.sc.getName().replace('.', '/'), null, Type.getInternalName(this.sc.getSuperClass()), interfaceStrs);
        this.checkOrCreateDefaultConstructor();
        for (IGlobalVariableCreator ifc : this.fieldCreators) {
            ifc.create((IClassContext)this, this.sc);
        }
        for (IMethodCreator imc : this.methodCreaters) {
            imc.create((IClassContext)this, this.sc);
        }
        this.checkUnImplementMethod();
        for (IGlobalVariableCreator ifc : this.fieldCreators) {
            ifc.prepare();
        }
        for (IMethodCreator imc : this.methodCreaters) {
            imc.prepare();
        }
        for (IGlobalVariableCreator ifc : this.fieldCreators) {
            ifc.execute();
        }
        for (IMethodCreator imc : this.methodCreaters) {
            imc.execute();
        }
        byte[] code = this.cw.toByteArray();
        if (StringUtils.isNotBlank((String)this.classOutPutPath)) {
            ClassFileUtils.toLocal(code, this.classOutPutPath, this.sc.getName());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End create class : " + this.sc.getName().replace('.', '/')));
        }
        return this.loadClass(this.sc.getName(), code);
    }

    private void checkOrCreateDefaultConstructor() {
        if (!this.haveInitMethod) {
            this.createDefaultConstructor();
        }
    }

    protected abstract void createDefaultConstructor();

    private void checkUnImplementMethod() {
        if (this.sc.isAbstract() || this.sc.isInterface()) {
            return;
        }
        ArrayList<java.lang.reflect.Method> abstractMethods = new ArrayList<java.lang.reflect.Method>();
        ArrayList<java.lang.reflect.Method> nonAbstractMethods = new ArrayList<java.lang.reflect.Method>();
        this.allMethodInClass(this.sc.getSuperClass(), abstractMethods, nonAbstractMethods);
        for (Class<?> inter : this.sc.getInterfaces()) {
            this.allMethodInClass(inter, abstractMethods, nonAbstractMethods);
        }
        int i = 0;
        while (i < abstractMethods.size()) {
            java.lang.reflect.Method abstractMethod = (java.lang.reflect.Method)abstractMethods.get(i);
            boolean exist = false;
            for (int j = 0; j < nonAbstractMethods.size(); ++j) {
                java.lang.reflect.Method nonAbstractMethod = (java.lang.reflect.Method)nonAbstractMethods.get(j);
                if (!MethodUtils.methodEqualWithoutOwner(abstractMethod, nonAbstractMethod)) continue;
                abstractMethods.remove(i);
                nonAbstractMethods.remove(j);
                exist = true;
                break;
            }
            if (exist) continue;
            ++i;
        }
        List<Method> scImplMethods = this.sc.getMethods();
        int i2 = 0;
        while (i2 < abstractMethods.size()) {
            java.lang.reflect.Method abstractMethod = (java.lang.reflect.Method)abstractMethods.get(i2);
            boolean exist = false;
            for (int j = 0; j < scImplMethods.size(); ++j) {
                Method nonAbstractMethod = scImplMethods.get(j);
                if (!MethodUtils.methodEqual(nonAbstractMethod.getMethodEntity(), abstractMethod)) continue;
                abstractMethods.remove(i2);
                scImplMethods.remove(j);
                exist = true;
                break;
            }
            if (exist) continue;
            ++i2;
        }
        if (!abstractMethods.isEmpty()) {
            String lineSeq = System.getProperty("line.separator");
            StringBuilder sb = new StringBuilder("The type ").append(this.sc).append(" must implement the inherited abstract method :").append(lineSeq);
            for (java.lang.reflect.Method m : abstractMethods) {
                sb.append(m.toString()).append(lineSeq);
            }
            throw new InternalError(sb.toString());
        }
    }

    private boolean containMethod(List<java.lang.reflect.Method> methods, java.lang.reflect.Method method) {
        if (CollectionUtils.isNotEmpty(methods)) {
            for (java.lang.reflect.Method m : methods) {
                if (!MethodUtils.methodEqualWithoutOwner(m, method)) continue;
                return true;
            }
        }
        return false;
    }

    private void allMethodInClass(Class<?> clazz, List<java.lang.reflect.Method> abstractMethods, List<java.lang.reflect.Method> nonAbstractMethods) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        Object[] methods = clazz.getDeclaredMethods();
        if (ArrayUtils.isNotEmpty((Object[])methods)) {
            for (Object m : methods) {
                if (ModifierUtils.isAbstract(((java.lang.reflect.Method)m).getModifiers())) {
                    if (this.containMethod(abstractMethods, (java.lang.reflect.Method)m)) continue;
                    abstractMethods.add((java.lang.reflect.Method)m);
                    continue;
                }
                if (this.containMethod(nonAbstractMethods, (java.lang.reflect.Method)m)) continue;
                nonAbstractMethods.add((java.lang.reflect.Method)m);
            }
        }
        this.allMethodInClass(clazz.getSuperclass(), abstractMethods, nonAbstractMethods);
        Object[] interfaces = clazz.getInterfaces();
        if (ArrayUtils.isNotEmpty((Object[])interfaces)) {
            for (Object interfaceClass : interfaces) {
                this.allMethodInClass((Class<?>)interfaceClass, abstractMethods, nonAbstractMethods);
            }
        }
    }
}

