/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.creator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jw.asmsupport.asm.proxy.VisitXInsnAdapter;
import jw.asmsupport.block.method.cinit.CInitBody;
import jw.asmsupport.block.method.common.CommonMethodBody;
import jw.asmsupport.block.method.common.MethodBodyForModify;
import jw.asmsupport.block.method.common.StaticMethodBody;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.clazz.ProductClass;
import jw.asmsupport.creator.AbstractClassContext;
import jw.asmsupport.creator.GlobalVariableCreator;
import jw.asmsupport.creator.IClassContext;
import jw.asmsupport.creator.IGlobalVariableCreator;
import jw.asmsupport.creator.IMethodCreator;
import jw.asmsupport.creator.MethodCreator;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.exception.NoSuchMethod;
import jw.asmsupport.loader.ClassModifierClassLoader;
import jw.asmsupport.utils.ClassFileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public class ClassModifier
extends AbstractClassContext {
    private static Log LOG = LogFactory.getLog(ClassModifier.class);
    protected List<IMethodCreator> methodModifiers;
    private List<MethodBodyForModify> modifyConstructorBodies;
    private ProductClass productClass;

    public ClassModifier(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new ASMSupportException("cannot modify array type : " + clazz);
        }
        this.productClass = (ProductClass)AClassFactory.getProductClass(clazz);
        this.methodCreaters = new ArrayList();
        this.methodModifiers = new ArrayList<IMethodCreator>();
        this.fieldCreators = new ArrayList();
    }

    public void modify(Map<String, List<VisitXInsnAdapter>> superConstructorMap) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start modify class : " + this.productClass.getReallyClass()));
        }
        for (IGlobalVariableCreator ifc : this.fieldCreators) {
            ifc.create((IClassContext)this, this.productClass);
        }
        for (IMethodCreator imc : this.methodCreaters) {
            imc.create((IClassContext)this, this.productClass);
        }
        for (IMethodCreator imc : this.methodModifiers) {
            imc.create((IClassContext)this, this.productClass);
        }
        if (this.modifyConstructorBodies != null) {
            for (MethodBodyForModify mbfm : this.modifyConstructorBodies) {
                Type[] argumentTypes = mbfm.getMethod().getMethodEntity().getArgTypes();
                String desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])argumentTypes);
                mbfm.setSuperConstructorOperators(superConstructorMap.get(desc));
            }
        }
        for (IGlobalVariableCreator ifc : this.fieldCreators) {
            ifc.prepare();
        }
        for (IMethodCreator imc : this.methodCreaters) {
            imc.prepare();
        }
        for (IMethodCreator imc : this.methodModifiers) {
            imc.prepare();
        }
        for (IGlobalVariableCreator ifc : this.fieldCreators) {
            ifc.execute();
        }
        for (IMethodCreator imc : this.methodCreaters) {
            imc.execute();
        }
        for (IMethodCreator imc : this.methodModifiers) {
            imc.execute();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End modify class : " + this.productClass.getReallyClass()));
        }
    }

    @Override
    public Class<?> startup() {
        ClassModifierClassLoader loader = new ClassModifierClassLoader(this);
        try {
            loader.loadClass(this.productClass.getName());
            String proxyClassName = this.productClass.getName();
            byte[] modifiedBytes = loader.getModifiedClassBytes();
            if (StringUtils.isNotBlank((String)this.getClassOutPutPath())) {
                ClassFileUtils.toLocal(modifiedBytes, this.getClassOutPutPath(), proxyClassName);
            }
            Class<?> clazz = this.loadClass(proxyClassName, modifiedBytes);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new ASMSupportException("Class Not Found Exception");
        }
    }

    public final void modifyMethod(String name, Class<?>[] argClasses, MethodBodyForModify mb) {
        Class<?> clazz = this.productClass.getReallyClass();
        if (argClasses == null) {
            argClasses = new Class[]{};
        }
        AClass[] argCls = new AClass[argClasses.length];
        String[] defaultArgNames = new String[argClasses.length];
        for (int i = 0; i < argCls.length; ++i) {
            argCls[i] = ClassModifier.getProductClass(argClasses[i]);
            defaultArgNames[i] = "arg" + i;
        }
        try {
            MethodCreator methodCreator;
            if (name.equals("<clinit>")) {
                methodCreator = MethodCreator.methodCreatorForModify(name, argCls, defaultArgNames, AClass.VOID_ACLASS, null, 8, mb);
            } else if (name.equals("<init>")) {
                if (this.modifyConstructorBodies == null) {
                    this.modifyConstructorBodies = new ArrayList<MethodBodyForModify>();
                }
                this.modifyConstructorBodies.add(mb);
                Constructor<?> constructor = clazz.getDeclaredConstructor(argClasses);
                methodCreator = MethodCreator.methodCreatorForModify("<init>", argCls, defaultArgNames, AClass.VOID_ACLASS, constructor.getExceptionTypes(), constructor.getModifiers(), mb);
            } else {
                Method method = clazz.getDeclaredMethod(name, argClasses);
                methodCreator = MethodCreator.methodCreatorForModify(name, argCls, defaultArgNames, ClassModifier.getProductClass(method.getReturnType()), method.getExceptionTypes(), method.getModifiers(), mb);
            }
            this.methodModifiers.add(methodCreator);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethod(this.productClass, name, argCls);
        }
    }

    public final void createMethod(String name, AClass[] argClasses, String[] argNames, AClass returnClass, Class<?>[] exceptions, int access, CommonMethodBody mb) {
        if ((access & 8) != 0) {
            access -= 8;
        }
        this.methodCreaters.add(MethodCreator.methodCreatorForAdd(name, argClasses, argNames, returnClass, exceptions, access, mb));
    }

    public void createStaticMethod(String name, AClass[] argClasses, String[] argNames, AClass returnClass, Class<?>[] exceptions, int access, StaticMethodBody mb) {
        if ((access & 8) == 0) {
            access += 8;
        }
        this.methodCreaters.add(MethodCreator.methodCreatorForAdd(name, argClasses, argNames, returnClass, exceptions, access, mb));
    }

    @Override
    protected void checkStaticBlock() {
        if (this.productClass.existStaticInitBlock()) {
            this.existedStaticBlock = true;
        }
        super.checkStaticBlock();
    }

    public void createStaticBlock(CInitBody mb) {
        this.checkStaticBlock();
        this.existedStaticBlock = true;
        this.methodCreaters.add(0, MethodCreator.methodCreatorForAdd("<clinit>", null, null, null, null, 8, mb));
    }

    public void createGlobalVariable(String name, int modifiers, AClass fieldClass) {
        GlobalVariableCreator fc = new GlobalVariableCreator(name, modifiers, fieldClass);
        this.fieldCreators.add(fc);
    }

    @Override
    public ProductClass getCurrentClass() {
        return this.productClass;
    }

    public void setClassWriter(ClassWriter cw) {
        if (this.cw == null) {
            this.cw = cw;
        }
    }

    public List<IMethodCreator> getMethodModifiers() {
        return this.methodModifiers;
    }
}

