/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.creator;

import java.util.ArrayList;
import java.util.List;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.method.cinit.EnumCInitBody;
import jw.asmsupport.block.method.common.CommonMethodBody;
import jw.asmsupport.block.method.common.StaticMethodBody;
import jw.asmsupport.block.method.init.EnumInitBody;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.creator.AbstractClassCreatorContext;
import jw.asmsupport.creator.GlobalVariableCreator;
import jw.asmsupport.creator.MethodCreator;
import jw.asmsupport.definition.variable.LocalVariable;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.utils.ModifierUtils;
import org.apache.commons.collections.CollectionUtils;

public class EnumCreator
extends AbstractClassCreatorContext {
    private boolean existEnumConstant;
    private boolean existField;
    private boolean existNoArgumentsConstructor;
    List<String> enumConstantNameList = new ArrayList<String>();

    public EnumCreator(int version, String name, Class<?>[] interfaces) {
        super(version, 16433, name, Enum.class, interfaces);
    }

    public void createGlobalVariable(String name, int modifiers, AClass fieldClass) {
        if (!this.existEnumConstant) {
            throw new ASMSupportException("first field must be an enum object of current enum type " + this.sc.getName());
        }
        GlobalVariableCreator fc = new GlobalVariableCreator(name, modifiers, fieldClass);
        this.fieldCreators.add(fc);
        this.existField = !ModifierUtils.isEnum(modifiers);
    }

    public void createEnumConstant(String name) {
        if (this.existField) {
            throw new ASMSupportException("declare enum constant must before other field");
        }
        this.existEnumConstant = true;
        this.sc.setEnumNum(this.sc.getEnumNum() + 1);
        this.enumConstantNameList.add(name);
        this.createGlobalVariable(name, 16409, this.sc);
    }

    public final void createMethod(String name, AClass[] argClasses, String[] argNames, AClass returnClass, Class<?>[] exceptions, int access, CommonMethodBody mb) {
        if ((access & 8) != 0) {
            access -= 8;
        }
        this.methodCreaters.add(MethodCreator.methodCreatorForAdd(name, argClasses, argNames, returnClass, exceptions, access, mb));
    }

    public void createStaticMethod(String name, AClass[] argClasses, String[] argNames, AClass returnClass, Class<?>[] exceptions, int access, StaticMethodBody mb) {
        if ((access & 8) == 0) {
            access += 8;
        }
        this.methodCreaters.add(MethodCreator.methodCreatorForAdd(name, argClasses, argNames, returnClass, exceptions, access, mb));
    }

    public void createConstructor(AClass[] argClasses, String[] argNames, EnumInitBody mb) {
        if (argNames == null) {
            argNames = new String[]{};
        }
        if (argClasses == null) {
            argClasses = new AClass[]{};
        }
        if (argNames.length != argClasses.length) {
            throw new IllegalArgumentException("different arugment class number and argument name number");
        }
        if (argNames.length == 0) {
            this.existNoArgumentsConstructor = true;
        }
        String[] enumArgNames = new String[argNames.length + 2];
        enumArgNames[0] = "name";
        enumArgNames[1] = "ordinal";
        System.arraycopy(argNames, 0, enumArgNames, 2, argNames.length);
        AClass[] enumArgClasses = new AClass[argClasses.length + 2];
        enumArgClasses[0] = AClass.STRING_ACLASS;
        enumArgClasses[1] = AClass.INT_ACLASS;
        System.arraycopy(argClasses, 0, enumArgClasses, 2, argClasses.length);
        this.methodCreaters.add(MethodCreator.methodCreatorForAdd("<init>", enumArgClasses, enumArgNames, null, null, 2, mb));
        this.haveInitMethod = true;
    }

    public void createStaticBlock(EnumCInitBody body) {
        this.checkStaticBlock();
        body.setEnumNameList(this.enumConstantNameList);
        if (this.existEnumConstant) {
            this.createGlobalVariable("ENUM$VALUES", 4122, AClassFactory.getArrayClass(this.sc, 1));
        }
        this.existedStaticBlock = true;
        this.methodCreaters.add(0, MethodCreator.methodCreatorForAdd("<clinit>", null, null, null, null, 8, body));
    }

    @Override
    protected void createDefaultConstructor() {
        this.createConstructor(null, null, new EnumInitBody(){

            @Override
            public void generateBody(LocalVariable ... argus) {
                this.runReturn();
            }
        });
        this.createDefaultStaticBlock();
    }

    private void createDefaultStaticBlock() {
        if (!this.existedStaticBlock && !CollectionUtils.isEmpty(this.enumConstantNameList) && this.existNoArgumentsConstructor) {
            this.createStaticBlock(new EnumCInitBody(){
                {
                    this.enumNameList = EnumCreator.this.enumConstantNameList;
                }

                @Override
                public void constructEnumField() {
                    for (String name : this.enumNameList) {
                        this.newEnum(name, new Parameterized[0]);
                    }
                }

                @Override
                public void blockBody() {
                    this.runReturn();
                }
            });
        }
    }
}

