/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.creator;

import jw.asmsupport.block.method.SuperMethodBody;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.clazz.NewMemberClass;
import jw.asmsupport.clazz.ProductClass;
import jw.asmsupport.clazz.SemiClass;
import jw.asmsupport.creator.IClassContext;
import jw.asmsupport.creator.IMethodCreator;
import jw.asmsupport.definition.method.Method;
import jw.asmsupport.entity.MethodEntity;
import jw.asmsupport.utils.ModifierUtils;

public class MethodCreator
implements IMethodCreator {
    private String name;
    private AClass[] arguments;
    private String[] argNames;
    private AClass returnClass;
    private Class<?>[] exceptions;
    private int access;
    private SuperMethodBody methodBody;
    private MethodEntity me;
    private Method method;
    private int mtdCrtMode;

    void setMethodCreateMode(int mode) {
        this.mtdCrtMode = mode;
    }

    public static MethodCreator methodCreatorForModify(String name, AClass[] arguments, String[] argNames, AClass returnClass, Class<?>[] exceptions, int access, SuperMethodBody mb) {
        MethodCreator mc = new MethodCreator(name, arguments, argNames, returnClass, exceptions, access, mb);
        mc.setMethodCreateMode(1);
        return mc;
    }

    public static MethodCreator methodCreatorForAdd(String name, AClass[] arguments, String[] argNames, AClass returnClass, Class<?>[] exceptions, int access, SuperMethodBody mb) {
        MethodCreator mc = new MethodCreator(name, arguments, argNames, returnClass, exceptions, access, mb);
        mc.setMethodCreateMode(0);
        return mc;
    }

    private MethodCreator(String name, AClass[] arguments, String[] argNames, AClass returnClass, Class<?>[] exceptions, int access, SuperMethodBody mb) {
        this.name = name;
        this.arguments = arguments;
        this.argNames = argNames;
        this.returnClass = returnClass;
        this.exceptions = exceptions;
        this.access = access;
        this.methodBody = mb;
    }

    @Override
    public void prepare() {
        if (!ModifierUtils.isAbstract(this.access)) {
            this.method.getMethodBody().prepare();
        }
    }

    @Override
    public void execute() {
        this.method.startup();
    }

    @Override
    public void create(IClassContext context, SemiClass owner) {
        this.create(context, (NewMemberClass)owner);
    }

    @Override
    public void create(IClassContext context, ProductClass owner) {
        this.create(context, (NewMemberClass)owner);
    }

    private void create(IClassContext context, NewMemberClass owner) {
        AClass[] exces;
        if (this.exceptions == null) {
            exces = new AClass[]{};
        } else {
            exces = new AClass[this.exceptions.length];
            for (int i = 0; i < this.exceptions.length; ++i) {
                exces[i] = AClassFactory.getProductClass(this.exceptions[i]);
            }
        }
        this.me = new MethodEntity(this.name, owner, owner, this.arguments, this.argNames, this.returnClass, exces, this.access);
        this.method = new Method(this.me, context, this.methodBody, this.mtdCrtMode);
        if (this.method.getMethodEntity().getName().equals("<init>")) {
            owner.addConstructor(this.method);
        } else {
            owner.addMethod(this.method);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AClass[] getArguments() {
        return this.arguments;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public AClass getReturnClass() {
        return this.returnClass;
    }

    public Class<?>[] getExceptions() {
        return this.exceptions;
    }

    public int getAccess() {
        return this.access;
    }

    @Override
    public String getMethodString() {
        return this.me.getMethodString();
    }
}

