/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.definition.method;

import java.util.Collection;
import jw.asmsupport.Executeable;
import jw.asmsupport.asm.CommonInstructionHelper;
import jw.asmsupport.asm.InstructionHelper;
import jw.asmsupport.asm.StackLocalMethodVisitor;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.block.control.Try;
import jw.asmsupport.block.method.SuperMethodBody;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.NewMemberClass;
import jw.asmsupport.creator.IClassContext;
import jw.asmsupport.definition.variable.LocalVariable;
import jw.asmsupport.entity.MethodEntity;
import jw.asmsupport.operators.util.ThrowExceptionContainer;
import jw.asmsupport.utils.LocalVariables;
import jw.asmsupport.utils.ModifierUtils;
import jw.asmsupport.utils.Scope;
import jw.asmsupport.utils.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Method {
    private MethodEntity me;
    private Stack stack;
    private int mode = 0;
    private LocalVariables locals;
    private InstructionHelper insnHelper;
    private SuperMethodBody methodBody;
    private int totalIns = 0;
    private IClassContext context;
    private String methodDesc;
    private ThrowExceptionContainer throwExceptions;
    private NewMemberClass methodOwner;
    private LocalVariable[] arguments;
    private Try nearlyTryBlock;

    public Method(MethodEntity me, IClassContext context, SuperMethodBody methodBody, int mode) {
        this.me = me;
        this.context = context;
        this.throwExceptions = new ThrowExceptionContainer();
        this.stack = new Stack();
        this.locals = new LocalVariables();
        this.mode = mode;
        CollectionUtils.addAll((Collection)this.throwExceptions, (Object[])me.getExceptions());
        Type[] argTypes = new Type[me.getArgClasses().length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = me.getArgClasses()[i].getType();
        }
        this.methodDesc = Type.getMethodDescriptor((Type)this.me.getReturnType(), (Type[])argTypes);
        this.insnHelper = new CommonInstructionHelper(this);
        if (!ModifierUtils.isAbstract(me.getModifier())) {
            this.methodBody = methodBody;
            this.methodBody.setScope(new Scope(this.locals, null));
            this.methodBody.setOwnerBlock(null);
            this.methodBody.setInsnHelper(this.insnHelper);
            this.methodOwner = context.getCurrentClass();
        }
    }

    private void getThrowExceptionsInProgramBlock(ProgramBlock block) {
        ThrowExceptionContainer blockExceptions = block.getThrowExceptions();
        if (blockExceptions != null) {
            for (AClass exp : blockExceptions) {
                this.throwExceptions.add(exp);
            }
        }
        for (Executeable exe : block.getExecuteQueue()) {
            if (!(exe instanceof ProgramBlock)) continue;
            this.getThrowExceptionsInProgramBlock((ProgramBlock)exe);
        }
    }

    private void createMethodVisitor() {
        if (!ModifierUtils.isAbstract(this.me.getModifier())) {
            for (Executeable exe : this.getMethodBody().getExecuteQueue()) {
                if (!(exe instanceof ProgramBlock)) continue;
                this.getThrowExceptionsInProgramBlock((ProgramBlock)exe);
            }
        }
        String[] exceptions = new String[this.throwExceptions.size()];
        int i = 0;
        for (AClass te : this.throwExceptions) {
            exceptions[i++] = te.getType().getInternalName();
        }
        MethodVisitor mv = this.context.getClassVisitor().visitMethod(this.me.getModifier(), this.me.getName(), this.methodDesc, null, exceptions);
        this.insnHelper.setMv(new StackLocalMethodVisitor(mv, this.stack));
    }

    public boolean isStatic() {
        return (this.me.getModifier() & 8) != 0;
    }

    public void startup() {
        this.createMethodVisitor();
        if (!ModifierUtils.isAbstract(this.me.getModifier())) {
            this.methodBody.execute();
            this.methodBody.endMethodBody();
        }
        this.insnHelper.endMethod();
    }

    public Stack getStack() {
        return this.stack;
    }

    public LocalVariables getLocals() {
        return this.locals;
    }

    public int nextInsNumber() {
        ++this.totalIns;
        return this.totalIns;
    }

    public SuperMethodBody getMethodBody() {
        return this.methodBody;
    }

    public InstructionHelper getInsnHelper() {
        return this.insnHelper;
    }

    public MethodEntity getMethodEntity() {
        return this.me;
    }

    public void removeThrowException(AClass exception) {
        this.throwExceptions.remove(exception);
    }

    public String getDesc() {
        return this.methodDesc;
    }

    public String toString() {
        return this.me.getMethodString();
    }

    public NewMemberClass getMethodOwner() {
        return this.methodOwner;
    }

    public LocalVariable[] getArguments() {
        return this.arguments;
    }

    public void setArguments(LocalVariable[] arguments) {
        this.arguments = arguments;
    }

    public int getMode() {
        return this.mode;
    }

    public Try getNearlyTryBlock() {
        return this.nearlyTryBlock;
    }

    public void setNearlyTryBlock(Try nearlyTryBlock) {
        this.nearlyTryBlock = nearlyTryBlock;
    }
}

