/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.definition.value;

import java.lang.reflect.Modifier;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.definition.value.IValue;
import jw.asmsupport.exception.ASMSupportException;
import org.objectweb.asm.Type;

public class Value
implements IValue {
    private AClass aclass;
    private Object value;

    public String toString() {
        return this.value + "(type is " + this.aclass + ")";
    }

    public Value(Boolean value) {
        this.aclass = AClass.BOOLEAN_ACLASS;
        this.setProperites(value);
    }

    public Value(Byte value) {
        this.aclass = AClass.BYTE_ACLASS;
        this.setProperites(value);
    }

    public Value(Short value) {
        this.aclass = AClass.SHORT_ACLASS;
        this.setProperites(value);
    }

    public Value(Character value) {
        this.aclass = AClass.CHAR_ACLASS;
        this.setProperites(value);
    }

    public Value(Integer value) {
        this.aclass = AClass.INT_ACLASS;
        this.setProperites(value);
    }

    public Value(Long value) {
        this.aclass = AClass.LONG_ACLASS;
        this.setProperites(value);
    }

    public Value(Float value) {
        this.aclass = AClass.FLOAT_ACLASS;
        this.setProperites(value);
    }

    public Value(Double value) {
        this.aclass = AClass.DOUBLE_ACLASS;
        this.setProperites(value);
    }

    public Value(String value) {
        this.aclass = AClass.STRING_ACLASS;
        this.setProperites(value);
    }

    private Value() {
    }

    public Value(AClass aclass) {
        this.aclass = AClass.CLASS_ACLASS;
        this.setProperites(aclass);
    }

    private void setProperites(Object value) {
        this.value = value;
    }

    public Type getType() {
        return this.aclass.getType();
    }

    public AClass getAClass() {
        return this.aclass;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public AClass getParamterizedType() {
        return this.aclass;
    }

    public static Value defaultValue(AClass aclass) {
        if (aclass.getName().equals(Integer.TYPE.getName())) {
            return new Value(0);
        }
        if (aclass.getName().equals(Short.TYPE.getName())) {
            return new Value((short)0);
        }
        if (aclass.getName().equals(Byte.TYPE.getName())) {
            return new Value((byte)0);
        }
        if (aclass.getName().equals(Boolean.TYPE.getName())) {
            return new Value(false);
        }
        if (aclass.getName().equals(Long.TYPE.getName())) {
            return new Value(0L);
        }
        if (aclass.getName().equals(Double.TYPE.getName())) {
            return new Value(0.0);
        }
        if (aclass.getName().equals(Character.TYPE.getName())) {
            return new Value(Character.valueOf('\u0000'));
        }
        if (aclass.getName().equals(Float.TYPE.getName())) {
            return new Value(Float.valueOf(0.0f));
        }
        Value v = new Value();
        v.aclass = aclass;
        v.value = null;
        return v;
    }

    public static Value nullValue(AClass type) {
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("the type of null value cannot be primitive type!");
        }
        return Value.defaultValue(type);
    }

    public static Value value(Object obj) {
        if (obj == null) {
            throw new NullPointerException("cannot support null value for this method, use nullValue(AClass type) method to get null value if you want get null!");
        }
        if (obj instanceof Integer) {
            return new Value((Integer)obj);
        }
        if (obj instanceof Short) {
            return new Value((Short)obj);
        }
        if (obj instanceof Byte) {
            return new Value((Byte)obj);
        }
        if (obj instanceof Boolean) {
            return new Value((Boolean)obj);
        }
        if (obj instanceof Long) {
            return new Value((Long)obj);
        }
        if (obj instanceof Double) {
            return new Value((Double)obj);
        }
        if (obj instanceof Character) {
            return new Value((Character)obj);
        }
        if (obj instanceof Float) {
            return new Value((Float)obj);
        }
        if (obj instanceof AClass) {
            return new Value((AClass)obj);
        }
        if (obj instanceof String) {
            return new Value((String)obj);
        }
        if (obj instanceof Class) {
            return new Value(AClassFactory.getProductClass((Class)obj));
        }
        throw new ASMSupportException("cannot support type " + obj.getClass() + " for this method!");
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        if (this.value == null) {
            block.getInsnHelper().push(this.getType());
            return;
        }
        if (this.aclass.getName().equals(Integer.TYPE.getName())) {
            block.getInsnHelper().push((Integer)this.value);
        } else if (this.aclass.getName().equals(Short.TYPE.getName())) {
            block.getInsnHelper().push((Short)this.value);
        } else if (this.aclass.getName().equals(Byte.TYPE.getName())) {
            block.getInsnHelper().push((Byte)this.value);
        } else if (this.aclass.getName().equals(Boolean.TYPE.getName())) {
            block.getInsnHelper().push((Boolean)this.value);
        } else if (this.aclass.getName().equals(Long.TYPE.getName())) {
            block.getInsnHelper().push((Long)this.value);
        } else if (this.aclass.getName().equals(Double.TYPE.getName())) {
            block.getInsnHelper().push((Double)this.value);
        } else if (this.aclass.getName().equals(Character.TYPE.getName())) {
            block.getInsnHelper().push(((Character)this.value).charValue());
        } else if (this.aclass.getName().equals(Float.TYPE.getName())) {
            block.getInsnHelper().push(((Float)this.value).floatValue());
        } else if (this.aclass.getName().equals(String.class.getName())) {
            block.getInsnHelper().push(this.value.toString());
        } else if (this.aclass.getName().equals(Class.class.getName())) {
            block.getInsnHelper().pushClass(((AClass)this.value).getType());
        }
    }

    @Override
    public void asArgument() {
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof Value)) {
            return false;
        }
        Value objval = (Value)obj;
        AClass curtyp = this.getParamterizedType();
        AClass objtyp = objval.getParamterizedType();
        if (this.value == null && objval.value == null) {
            if (curtyp.isChildOrEqual(objtyp) || objtyp.isChildOrEqual(curtyp)) {
                return true;
            }
            if (Modifier.isAbstract(curtyp.getModifiers()) && Modifier.isFinal(objtyp.getModifiers())) {
                return false;
            }
            return !Modifier.isAbstract(objtyp.getModifiers()) || !Modifier.isFinal(curtyp.getModifiers());
        }
        if (this.value == null && objval.value != null || objval.value == null && this.value != null) {
            return false;
        }
        return this.value.equals(objval);
    }
}

