/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.definition.variable;

import java.lang.reflect.Modifier;
import jw.asmsupport.Crementable;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.definition.variable.IVariable;
import jw.asmsupport.definition.variable.MemberVariable;
import jw.asmsupport.entity.GlobalVariableEntity;
import jw.asmsupport.entity.VariableEntity;
import jw.asmsupport.operators.AbstractOperator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlobalVariable
extends MemberVariable
implements Crementable {
    private static Log log = LogFactory.getLog(GlobalVariable.class);
    private GlobalVariableEntity gve;
    private AClass staticOwner;
    private IVariable variableOwner;

    public GlobalVariable(AClass owner, AClass declareClass, int modifiers, String name) {
        this.gve = new GlobalVariableEntity(owner, declareClass, modifiers, name);
        this.staticOwner = owner;
    }

    public GlobalVariable(AClass owner, GlobalVariableEntity gve) {
        this.gve = gve;
        this.staticOwner = owner;
    }

    public GlobalVariable(IVariable var, AClass declareClass, int modifiers, String name) {
        this.gve = new GlobalVariableEntity(var.getParamterizedType(), declareClass, modifiers, name);
        this.variableOwner = var;
    }

    public GlobalVariable(IVariable var, GlobalVariableEntity gve) {
        this.gve = gve;
        this.variableOwner = var;
    }

    @Override
    public AClass getParamterizedType() {
        return this.gve.getDeclareClass();
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        if (Modifier.isStatic(this.gve.getModifiers())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("get field " + this.gve.getName() + " from class " + this.gve.getOwner().getName() + " and push to stack!"));
            }
            block.getInsnHelper().getStatic(this.staticOwner.getType(), this.gve.getName(), this.gve.getDeclareClass().getType());
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("get field " + this.gve.getName() + " from variable " + this.gve.getName() + " and push to stack!"));
            }
            this.variableOwner.loadToStack(block);
            block.getInsnHelper().getField(this.gve.getOwner().getType(), this.gve.getName(), this.gve.getDeclareClass().getType());
        }
    }

    public AClass getStaticOwner() {
        return this.staticOwner;
    }

    public IVariable getVariableOwner() {
        return this.variableOwner;
    }

    @Override
    public boolean availableFor(AbstractOperator operator) {
        return true;
    }

    public GlobalVariableEntity getGlobalVariableEntity() {
        return this.gve;
    }

    @Override
    public VariableEntity getVariableEntity() {
        return this.gve;
    }

    @Override
    public GlobalVariable getGlobalVariable(String name) {
        return this.getGlobalVariable(this.gve.getDeclareClass(), name);
    }

    public String toString() {
        return this.gve.getName();
    }
}

