/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.definition.variable;

import jw.asmsupport.Crementable;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.definition.variable.GlobalVariable;
import jw.asmsupport.definition.variable.MemberVariable;
import jw.asmsupport.entity.LocalVariableEntity;
import jw.asmsupport.entity.VariableEntity;
import jw.asmsupport.operators.AbstractOperator;
import jw.asmsupport.utils.Scope;
import jw.asmsupport.utils.ScopeLogicVariable;

public class LocalVariable
extends MemberVariable
implements Crementable {
    private LocalVariableEntity lve;
    protected ScopeLogicVariable scopeLogicVar;
    private boolean isFirstAssign = true;

    public LocalVariable(LocalVariableEntity lve) {
        this.lve = lve;
    }

    @Override
    public boolean availableFor(AbstractOperator operator) {
        Scope operScope = operator.getBlock().getScope();
        if (this.scopeLogicVar.isSubOf(operScope) ? this.scopeLogicVar.getCompileOrder() > operator.getCompileOrder() : !this.scopeLogicVar.availableFor(operator.getBlock().getScope())) {
            throw new VariableOperatorException();
        }
        return true;
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        block.getMethod().getInsnHelper().loadInsn(this.lve.getDeclareClass().getType(), this.scopeLogicVar.getInitStartPos());
    }

    public LocalVariableEntity getLocalVariableEntity() {
        return this.lve;
    }

    @Override
    public AClass getParamterizedType() {
        return this.lve.getDeclareClass();
    }

    @Override
    public VariableEntity getVariableEntity() {
        return this.lve;
    }

    public void setScopeLogicVar(ScopeLogicVariable scopeLogicVar) {
        this.scopeLogicVar = scopeLogicVar;
    }

    public ScopeLogicVariable getScopeLogicVar() {
        return this.scopeLogicVar;
    }

    public void setVariableCompileOrder(int complieOrder) {
        if (this.isFirstAssign) {
            this.scopeLogicVar.setCompileOrder(complieOrder);
            this.isFirstAssign = false;
        }
    }

    @Override
    public GlobalVariable getGlobalVariable(String name) {
        return this.getGlobalVariable(this.lve.getDeclareClass(), name);
    }

    public String toString() {
        return this.lve.getName();
    }

    private class VariableOperatorException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private VariableOperatorException() {
            super("the scope cannot use the variable \"" + LocalVariable.this.lve.getName() + "\"");
        }
    }
}

