/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.entity;

import java.lang.reflect.Method;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.exception.ASMSupportException;
import org.objectweb.asm.Type;

public class MethodEntity
implements Cloneable {
    private String name;
    private AClass owner;
    private AClass actuallyOwner;
    private Type[] argTypes;
    private AClass[] argClasses;
    private String[] argNames;
    private Type returnType;
    private int modifier;
    private AClass[] exceptions;
    private AClass returnClass;
    private String methodStr;

    public MethodEntity(String name, AClass owner, AClass actuallyOwner, AClass[] argClasses, String[] argNames, AClass returnClass, AClass[] exceptions, int modifier) {
        if (argClasses == null) {
            argClasses = new AClass[]{};
        }
        if (argNames == null) {
            argNames = new String[]{};
        }
        if (exceptions == null) {
            exceptions = new AClass[]{};
        }
        this.exceptions = exceptions;
        this.name = name;
        this.owner = owner;
        this.actuallyOwner = actuallyOwner;
        this.argNames = argNames;
        this.modifier = modifier;
        this.argClasses = argClasses;
        if (argClasses.length != argNames.length) {
            throw new ASMSupportException("different length between argClasses and argNames");
        }
        this.argTypes = new Type[argClasses.length];
        for (int i = 0; i < argClasses.length; ++i) {
            this.argTypes[i] = argClasses[i].getType();
        }
        if (returnClass == null) {
            this.returnType = Type.VOID_TYPE;
            this.returnClass = AClass.VOID_ACLASS;
        } else {
            this.returnType = returnClass.getType();
            this.returnClass = returnClass;
        }
    }

    public String getMethodString() {
        if (this.methodStr == null) {
            this.methodStr = this.actuallyOwner.toString() + "." + MethodEntity.getMethodString(this.name, this.argClasses);
        }
        return this.methodStr;
    }

    public static String getMethodString(String name, AClass[] arguments) {
        if (arguments == null) {
            arguments = new AClass[]{};
        }
        StringBuilder str = new StringBuilder(name).append("(");
        for (int i = 0; i < arguments.length; ++i) {
            str.append(arguments[i].getName()).append(", ");
        }
        if (arguments.length > 0) {
            str.delete(str.length() - 2, str.length());
        }
        str.append(")");
        return str.toString();
    }

    public static MethodEntity methodToMethodEntity(AClass owner, Method m) {
        Class<?>[] argCls = m.getParameterTypes();
        AClass[] arguments = new AClass[argCls.length];
        String[] argNames = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = AClassFactory.getProductClass(argCls[i]);
            argNames[i] = "arg" + i;
        }
        MethodEntity me = new MethodEntity(m.getName(), owner, AClassFactory.getProductClass(m.getDeclaringClass()), arguments, argNames, AClassFactory.getProductClass(m.getReturnType()), null, m.getModifiers());
        return me;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ASMSupportException("cannot clone this");
        }
    }

    public String toString() {
        return this.getMethodString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AClass getOwner() {
        return this.owner;
    }

    public Type[] getArgTypes() {
        return this.argTypes;
    }

    public AClass[] getArgClasses() {
        return this.argClasses;
    }

    public String[] getArgNames() {
        return this.argNames;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public int getModifier() {
        return this.modifier;
    }

    public AClass getReturnClass() {
        return this.returnClass;
    }

    public AClass getActuallyOwner() {
        return this.actuallyOwner;
    }

    public AClass[] getExceptions() {
        return this.exceptions;
    }
}

