/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.loader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import jw.asmsupport.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class ASMClassLoader
extends ClassLoader {
    public static ASMClassLoader asmClassLoader = new ASMClassLoader(Thread.currentThread().getContextClassLoader());
    private Map<Key, byte[]> classByteMap = new Hashtable<Key, byte[]>();

    private ASMClassLoader(ClassLoader parent) {
        super(parent);
    }

    public final Class<?> defineClass(String name, byte[] b) throws ClassFormatError {
        Class<?> clazz = super.defineClass(name, b, 0, b.length);
        this.classByteMap.put(new Key(clazz), b);
        return clazz;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Set<Key> keySet = this.classByteMap.keySet();
        if (CollectionUtils.isNotEmpty(keySet)) {
            for (Key k : keySet) {
                if (!k.equals(new Key(name))) continue;
                return k.clazz;
            }
        }
        return super.findClass(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] byteArray = this.classByteMap.get(new Key(name));
        InputStream stream = null;
        if (byteArray != null) {
            stream = new ByteArrayInputStream(byteArray);
        }
        if (stream == null) {
            stream = super.getResourceAsStream(name);
        }
        return stream;
    }

    private String translateClassName(String classQualifiedName) {
        return classQualifiedName.replace('.', '/') + ".class";
    }

    private class Key {
        private Class<?> clazz;
        private String name;

        public Key(Class<?> clazz) {
            this.clazz = clazz;
        }

        public Key(String name) {
            this.name = name;
        }

        public int hashCode() {
            if (this.clazz != null) {
                return ASMClassLoader.this.translateClassName(this.clazz.getName()).hashCode();
            }
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Key) {
                String compareName;
                Key k = (Key)obj;
                String currentName = this.clazz == null ? this.name : ASMClassLoader.this.translateClassName(this.clazz.getName());
                String string = compareName = k.clazz == null ? k.name : ASMClassLoader.this.translateClassName(k.clazz.getName());
                if (StringUtils.equals((String)currentName, (String)compareName)) {
                    return true;
                }
            }
            return false;
        }
    }
}

