/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators;

import java.util.LinkedList;
import java.util.List;
import jw.asmsupport.asm.InstructionHelper;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.definition.AbstractExecuteable;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.exception.UnreachableCode;
import jw.asmsupport.operators.BlockEndFlag;
import jw.asmsupport.operators.asmdirect.Marker;
import jw.asmsupport.operators.asmdirect.NOP;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import jw.asmsupport.utils.AClassUtils;
import org.objectweb.asm.Type;

public abstract class AbstractOperator
extends AbstractExecuteable {
    protected ProgramBlock block;
    protected InstructionHelper insnHelper;
    private int compileOrder;
    protected List<AbstractCrement> allCrement;

    protected AbstractOperator(ProgramBlock block) {
        this.insnHelper = block.getInsnHelper();
        this.block = block;
        block.addExe(this);
        this.allCrement = new LinkedList<AbstractCrement>();
    }

    public ProgramBlock getBlock() {
        return this.block;
    }

    public void checkUnreachableCode() {
        boolean unreach;
        if (this.block.whetherCheckUnreachableCode() && this.block.getExecuteQueue().contains(this) && !(this instanceof Marker) && !(this instanceof NOP) && !(this instanceof BlockEndFlag) && (unreach = this.block.isUnreachableCode(this))) {
            throw new UnreachableCode("Unreachable code when " + this, this.block, this);
        }
    }

    @Override
    public final void prepare() {
        this.firstPrepareProcess();
        this.beforeInitProperties();
        this.verifyArgument();
        this.checkOutCrement();
        this.afterInitProperties();
        this.lastPrepareProcess();
    }

    protected void firstPrepareProcess() {
    }

    protected void beforeInitProperties() {
    }

    protected void verifyArgument() {
    }

    protected void checkOutCrement() {
    }

    protected void checkAsArgument() {
    }

    protected void afterInitProperties() {
    }

    protected void lastPrepareProcess() {
    }

    @Override
    public void execute() {
        for (AbstractCrement c : this.allCrement) {
            c.before();
        }
        this.compileOrder = this.insnHelper.getMethod().nextInsNumber();
        this.executing();
        for (AbstractCrement c : this.allCrement) {
            c.after();
        }
    }

    protected abstract void executing();

    protected void autoCast(AClass from, AClass to) {
        if (from.isChildOrEqual(to)) {
            return;
        }
        if (from.isPrimitive() && to.isPrimitive()) {
            if (!from.equals(AClass.BOOLEAN_ACLASS) && !to.equals(AClass.BOOLEAN_ACLASS) && from.getCastOrder() <= to.getCastOrder()) {
                this.insnHelper.cast(from.getType(), to.getType());
                return;
            }
        } else {
            if (from.isPrimitive() && (AClassUtils.getPrimitiveWrapAClass(from).equals(to) || to.equals(AClass.OBJECT_ACLASS))) {
                this.insnHelper.box(from.getType());
                return;
            }
            if (AClassUtils.isPrimitiveWrapAClass(from) && from.equals(AClassUtils.getPrimitiveWrapAClass(to))) {
                Type primType = InstructionHelper.getUnBoxedType(from.getType());
                this.insnHelper.unbox(from.getType());
                this.insnHelper.cast(primType, to.getType());
                return;
            }
        }
        throw new ASMSupportException("cannot auto cast from " + from + " to " + to + " also you can use CheckCast to try again!");
    }

    public final int getCompileOrder() {
        return this.compileOrder;
    }
}

