/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.AbstractOperator;

public class InstanceofOperator
extends AbstractOperator
implements Parameterized {
    private AClass type;
    private Parameterized obj;
    private boolean byOtherUsed;

    protected InstanceofOperator(ProgramBlock block, Parameterized obj, AClass type) {
        super(block);
        this.obj = obj;
        this.type = type;
    }

    @Override
    protected void verifyArgument() {
        if (this.obj.getParamterizedType().isPrimitive()) {
            throw new ASMSupportException("Incompatible conditional operand types " + this.obj.getParamterizedType() + " int and " + this.type);
        }
    }

    @Override
    protected void checkOutCrement() {
    }

    @Override
    protected void checkAsArgument() {
        this.obj.asArgument();
    }

    @Override
    public void execute() {
        if (!this.byOtherUsed) {
            throw new ASMSupportException("the instanceof operator has not been used by other operator.");
        }
        super.execute();
    }

    @Override
    protected void executing() {
        this.obj.loadToStack(this.block);
        this.insnHelper.instanceOf(this.type.getType());
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        this.execute();
    }

    @Override
    public AClass getParamterizedType() {
        return AClass.BOOLEAN_ACLASS;
    }

    @Override
    public void asArgument() {
        this.byOtherUsed = true;
        this.block.removeExe(this);
    }
}

