/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.operators.BreakStack;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Type;

public class Return
extends BreakStack {
    private static Log log = LogFactory.getLog(Return.class);
    private Parameterized returner;
    private Type returnType;

    protected Return(ProgramBlock block, Parameterized returner) {
        super(block);
        this.returner = returner;
        if (returner != null) {
            returner.asArgument();
        }
    }

    @Override
    protected void verifyArgument() {
    }

    @Override
    protected void checkOutCrement() {
        if (this.returner instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.returner);
        }
    }

    @Override
    protected void checkAsArgument() {
    }

    @Override
    public void breakStackExecuting() {
        if (this.returner == null) {
            log.debug((Object)"direct return from method");
            this.insnHelper.returnInsn();
        } else {
            this.returner.loadToStack(this.block);
            this.returnType = this.returner.getParamterizedType().getType();
            if (this.returnType == null) {
                throw new NullPointerException("return type must be non-null!");
            }
            this.insnHelper.returnInsn(this.returnType);
        }
    }
}

