/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.array;

import jw.asmsupport.Parameterized;
import jw.asmsupport.asm.InstructionHelper;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.exception.ClassException;
import jw.asmsupport.operators.AbstractOperator;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import jw.asmsupport.utils.AClassUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractArrayOperator
extends AbstractOperator {
    private static Log log = LogFactory.getLog(AbstractArrayOperator.class);
    protected Parameterized arrayReference;
    protected Parameterized[] parDims;

    protected AbstractArrayOperator(ProgramBlock block, Parameterized arrayVar) {
        super(block);
        this.arrayReference = arrayVar;
    }

    @Override
    protected final void checkOutCrement() {
        if (this.parDims != null) {
            for (Parameterized par : this.parDims) {
                if (!(par instanceof AbstractCrement)) continue;
                this.allCrement.add((AbstractCrement)par);
            }
        }
    }

    @Override
    protected void checkAsArgument() {
        this.arrayReference.asArgument();
        if (this.parDims != null) {
            for (Parameterized par : this.parDims) {
                par.asArgument();
            }
        }
    }

    @Override
    protected void verifyArgument() {
        if (!(this.arrayReference.getParamterizedType() instanceof ArrayClass)) {
            throw new ClassException(this.toString() + " : the declare class of " + this.arrayReference.toString() + " is not a array type");
        }
        if (ArrayUtils.isNotEmpty((Object[])this.parDims)) {
            for (Parameterized par : this.parDims) {
                AClassUtils.autoCastTypeCheck(par.getParamterizedType(), AClass.INT_ACLASS);
            }
        }
    }

    protected void getValue() {
        InstructionHelper ih = this.block.getInsnHelper();
        AClass cls = this.arrayReference.getParamterizedType();
        if (log.isDebugEnabled()) {
            log.debug((Object)"load the array reference to stack");
        }
        this.arrayReference.loadToStack(this.block);
        for (int i = 0; i < this.parDims.length; ++i) {
            cls = ((ArrayClass)cls).getNextDimType();
            this.parDims[i].loadToStack(this.block);
            this.autoCast(this.parDims[i].getParamterizedType(), AClass.INT_ACLASS);
            ih.arrayLoad(cls.getType());
        }
    }
}

