/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.array;

import jw.asmsupport.Parameterized;
import jw.asmsupport.asm.InstructionHelper;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.operators.array.AbstractArrayOperator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArrayLength
extends AbstractArrayOperator
implements Parameterized {
    private static Log log = LogFactory.getLog(ArrayLength.class);
    private boolean useByOther;

    protected ArrayLength(ProgramBlock block, Parameterized arrayReference, Parameterized ... parDims) {
        super(block, arrayReference);
        this.parDims = parDims;
    }

    @Override
    public void executing() {
        if (!this.useByOther) {
            throw new RuntimeException(this.toString() + " not use by other operator");
        }
        InstructionHelper ih = this.block.getInsnHelper();
        if (log.isDebugEnabled()) {
            log.debug((Object)"start get length of array");
        }
        this.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)"got length and push to stack");
        }
        ih.arrayLength();
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        this.execute();
    }

    @Override
    public AClass getParamterizedType() {
        return AClass.INT_ACLASS;
    }

    @Override
    public void asArgument() {
        this.useByOther = true;
        this.block.removeExe(this);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder(this.arrayReference.toString());
        for (Parameterized p : this.parDims) {
            toString.append("[").append(p).append("]");
        }
        toString.append(".length");
        return toString.toString();
    }
}

