/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.array;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.exception.ArrayOperatorException;
import jw.asmsupport.operators.array.AbstractArrayOperator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArrayLoader
extends AbstractArrayOperator
implements Parameterized {
    private static Log log = LogFactory.getLog(ArrayLoader.class);
    private AClass valueClass;
    private boolean useByOther;

    private void init(Parameterized pardim, Parameterized ... parDims) {
        this.parDims = new Parameterized[1 + parDims.length];
        this.parDims[0] = pardim;
        System.arraycopy(parDims, 0, this.parDims, 1, parDims.length);
        this.valueClass = this.arrayReference.getParamterizedType();
        for (int i = 0; i < this.parDims.length; ++i) {
            this.valueClass = ((ArrayClass)this.valueClass).getNextDimType();
        }
    }

    protected ArrayLoader(ProgramBlock block, Parameterized arrayReference, Parameterized pardim, Parameterized ... parDims) {
        super(block, arrayReference);
        this.init(pardim, parDims);
    }

    @Override
    public void executing() {
        if (!this.useByOther) {
            throw new RuntimeException(this.toString() + " not use by other operator");
        }
        ArrayClass cls = (ArrayClass)this.arrayReference.getParamterizedType();
        if (this.parDims != null && this.parDims.length > cls.getDimension()) {
            throw new ArrayOperatorException(this.toString() + " dimension not enough!");
        }
        log.debug((Object)"start load array value");
        this.getValue();
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        this.execute();
    }

    @Override
    public AClass getParamterizedType() {
        return this.valueClass;
    }

    @Override
    public void asArgument() {
        this.useByOther = true;
        this.block.removeExe(this);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder(this.arrayReference.toString());
        for (Parameterized p : this.parDims) {
            toString.append("[").append(p).append("]");
        }
        return toString.toString();
    }
}

