/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.array;

import jw.asmsupport.Parameterized;
import jw.asmsupport.asm.InstructionHelper;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.operators.array.AbstractArrayOperator;
import jw.asmsupport.utils.AClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArrayStorer
extends AbstractArrayOperator {
    private static Log log = LogFactory.getLog(ArrayStorer.class);
    private Parameterized value;
    private AClass storeClass;
    private Parameterized lastDim;

    private void init(Parameterized value, Parameterized pardim, Parameterized ... parDims) {
        this.value = value;
        this.parDims = new Parameterized[parDims.length];
        if (parDims.length != 0) {
            this.parDims[0] = pardim;
            System.arraycopy(parDims, 0, this.parDims, 1, parDims.length - 1);
            this.lastDim = parDims[parDims.length - 1];
        } else {
            this.lastDim = pardim;
        }
        this.storeClass = this.arrayReference.getParamterizedType();
        int length = this.parDims.length + 1;
        for (int i = 0; i < length; ++i) {
            this.storeClass = ((ArrayClass)this.storeClass).getNextDimType();
        }
    }

    protected ArrayStorer(ProgramBlock block, Parameterized arrayReference, Parameterized value, Parameterized pardim, Parameterized ... parDims) {
        super(block, arrayReference);
        this.init(value, pardim, parDims);
    }

    @Override
    protected void checkAsArgument() {
        super.checkAsArgument();
        this.value.asArgument();
    }

    @Override
    protected void verifyArgument() {
        super.verifyArgument();
        AClassUtils.autoCastTypeCheck(this.value.getParamterizedType(), this.storeClass);
        AClassUtils.autoCastTypeCheck(this.lastDim.getParamterizedType(), AClass.INT_ACLASS);
    }

    @Override
    public void executing() {
        log.debug((Object)"start get value for store array");
        this.getValue();
        InstructionHelper ih = this.block.getInsnHelper();
        log.debug((Object)"push the last dim index to stack");
        this.lastDim.loadToStack(this.block);
        this.autoCast(this.lastDim.getParamterizedType(), AClass.INT_ACLASS);
        this.value.loadToStack(this.block);
        this.autoCast(this.value.getParamterizedType(), this.storeClass);
        log.debug((Object)"store value to corresponse to index of the array");
        ih.arrayStore(this.storeClass.getType());
    }
}

