/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.array;

import java.lang.reflect.Array;
import jw.asmsupport.Parameterized;
import jw.asmsupport.asm.InstructionHelper;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.operators.AbstractOperator;
import jw.asmsupport.utils.AClassUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArrayValue
extends AbstractOperator
implements Parameterized {
    private static Log log = LogFactory.getLog(ArrayValue.class);
    private ArrayClass arrayCls;
    private Parameterized[] allocateDims;
    private Object values;
    private boolean useByOther;

    private void batchAsArgument(Object values) {
        new EachValue(values){

            @Override
            void process(Parameterized para) {
                para.asArgument();
            }
        }.process();
    }

    protected ArrayValue(ProgramBlock block, ArrayClass arrayCls, Parameterized ... allocateDims) {
        super(block);
        if (arrayCls.getDimension() < allocateDims.length) {
            throw new IllegalArgumentException("dimension not enough: array type is " + arrayCls + " and allocate dims is " + ArrayUtils.toString((Object)allocateDims));
        }
        this.arrayCls = arrayCls;
        this.allocateDims = allocateDims;
    }

    protected ArrayValue(ProgramBlock block, ArrayClass arrayCls, Object values) {
        super(block);
        this.arrayCls = arrayCls;
        this.values = values;
        if (values != null && !values.getClass().isArray()) {
            throw new IllegalArgumentException("values must be an array");
        }
        int dim = new EachValue(values){

            @Override
            void process(Parameterized para) {
            }
        }.process();
        if (arrayCls.getDimension() != dim) {
            throw new IllegalArgumentException("different dimension : value dimension is " + dim + ", class(" + arrayCls + ") dimension is " + arrayCls.getDimension());
        }
    }

    @Override
    protected void firstPrepareProcess() {
    }

    @Override
    protected void beforeInitProperties() {
    }

    @Override
    protected void verifyArgument() {
        if (this.allocateDims != null) {
            for (Parameterized dim : this.allocateDims) {
                int order = AClassUtils.getPrimitiveAClass(dim.getParamterizedType()).getCastOrder();
                if (order <= AClass.INT_ACLASS.getCastOrder() && order > AClass.BOOLEAN_ACLASS.getCastOrder()) continue;
                throw new RuntimeException("the allcate dim number must be byte, char, short or int type!");
            }
        }
        final AClass rootComp = this.arrayCls.getRootComponentClass();
        new EachValue(this.values){

            @Override
            void process(Parameterized para) {
                AClassUtils.autoCastTypeCheck(para.getParamterizedType(), rootComp);
            }
        }.process();
    }

    @Override
    protected void checkOutCrement() {
    }

    @Override
    protected void checkAsArgument() {
        this.batchAsArgument(this.allocateDims);
        this.batchAsArgument(this.values);
    }

    @Override
    protected void afterInitProperties() {
    }

    @Override
    protected void lastPrepareProcess() {
    }

    private void loopArray(AClass acls, Object arrayOrElement) {
        InstructionHelper ih = this.block.getInsnHelper();
        if (arrayOrElement.getClass().isArray()) {
            int len = Array.getLength(arrayOrElement);
            ih.push(len);
            AClass nextDimType = ((ArrayClass)acls).getNextDimType();
            ih.newArray(nextDimType.getType());
            if (len > 0) {
                ih.dup();
            }
            for (int i = 0; i < len; ++i) {
                ih.push(i);
                this.loopArray(nextDimType, Array.get(arrayOrElement, i));
                ih.arrayStore(acls.getType());
                if (i >= len - 1) continue;
                ih.dup();
            }
        } else {
            ((Parameterized)arrayOrElement).loadToStack(this.block);
            this.autoCast(((Parameterized)arrayOrElement).getParamterizedType(), acls);
        }
    }

    @Override
    protected void executing() {
        if (!this.useByOther) {
            throw new RuntimeException("this array value not use by other operator");
        }
        if (this.allocateDims != null) {
            log.debug((Object)"start new a array!");
            InstructionHelper ih = this.block.getInsnHelper();
            if (this.allocateDims == null || this.allocateDims.length == 0) {
                ih.push(this.arrayCls.getType());
                ih.checkCast(this.arrayCls.getType());
                return;
            }
            if (this.allocateDims.length == 1) {
                this.allocateDims[0].loadToStack(this.block);
                ih.unbox(this.allocateDims[0].getParamterizedType().getType());
                ih.newArray(this.arrayCls.getNextDimType().getType());
            } else {
                for (Parameterized allocate : this.allocateDims) {
                    allocate.loadToStack(this.block);
                    ih.unbox(allocate.getParamterizedType().getType());
                }
                ih.multiANewArrayInsn(this.arrayCls.getType(), this.allocateDims.length);
            }
        } else {
            this.loopArray(this.arrayCls, this.values);
        }
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        this.execute();
    }

    @Override
    public AClass getParamterizedType() {
        return this.arrayCls;
    }

    @Override
    public void asArgument() {
        this.useByOther = true;
        this.block.removeExe(this);
    }

    public String toString() {
        return "new " + this.arrayCls.toString() + " " + super.toString();
    }

    private abstract class EachValue {
        private Object array;

        private EachValue(Object array) {
            this.array = array;
        }

        int process() {
            if (this.array != null) {
                return this.loopProcess(this.array, 0);
            }
            return 0;
        }

        private int loopProcess(Object object, int over) {
            if (object.getClass().isArray()) {
                int len = Array.getLength(object);
                int preArrayDoor = -1;
                for (int i = 0; i < len; ++i) {
                    Object o = Array.get(object, i);
                    int curArrayDoor = this.loopProcess(o, over + 1);
                    if (preArrayDoor == -1 || preArrayDoor == curArrayDoor) {
                        preArrayDoor = curArrayDoor;
                        continue;
                    }
                    if (preArrayDoor == curArrayDoor) continue;
                    throw new IllegalArgumentException("This array exist different dim sub-array : " + ArrayUtils.toString((Object)this.array));
                }
                return preArrayDoor == -1 ? over + 1 : preArrayDoor;
            }
            try {
                this.process((Parameterized)object);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("exception occur when " + ArrayValue.this.toString(), e);
            }
            return over;
        }

        abstract void process(Parameterized var1);
    }
}

