/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.assign;

import java.lang.reflect.Modifier;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.definition.variable.GlobalVariable;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.assign.Assigner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlobalVariableAssigner
extends Assigner {
    private static Log log = LogFactory.getLog(GlobalVariableAssigner.class);
    private GlobalVariable var;

    protected GlobalVariableAssigner(ProgramBlock block, GlobalVariable var, Parameterized value) {
        super(block, var, value);
        this.var = var;
    }

    @Override
    public void executing() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("assign value to global variable '" + this.var.getVariableEntity().getName() + "' from " + this.value));
        }
        if (!Modifier.isStatic(this.var.getVariableEntity().getModifiers())) {
            if (Modifier.isStatic(this.block.getMethod().getMethodEntity().getModifier())) {
                throw new ASMSupportException("current method " + this.block.getMethod() + " is static cannot use non-static field " + this.var.getVariableEntity().getName());
            }
            this.var.getVariableOwner().loadToStack(this.block);
        }
        this.value.loadToStack(this.block);
        this.autoCast();
        if (this.var.getStaticOwner() != null) {
            this.insnHelper.putStatic(this.var.getStaticOwner().getType(), this.var.getVariableEntity().getName(), this.var.getVariableEntity().getDeclareClass().getType());
        } else if (this.var.getVariableOwner() != null) {
            this.insnHelper.putField(this.var.getVariableOwner().getVariableEntity().getDeclareClass().getType(), this.var.getVariableEntity().getName(), this.var.getVariableEntity().getDeclareClass().getType());
        }
    }
}

