/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.checkcast;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.operators.AbstractOperator;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckCast
extends AbstractOperator
implements Parameterized {
    private static Log log = LogFactory.getLog(CheckCast.class);
    private AClass to;
    private Parameterized orginal;

    protected CheckCast(ProgramBlock block, Parameterized orgi, AClass to) {
        super(block);
        this.orginal = orgi;
        this.to = to;
    }

    @Override
    protected void verifyArgument() {
    }

    @Override
    protected void checkOutCrement() {
        if (this.orginal instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.orginal);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.orginal.asArgument();
    }

    @Override
    public void executing() {
        this.orginal.loadToStack(this.block);
        AClass from = this.orginal.getParamterizedType();
        if (this.to.equals(from)) {
            return;
        }
        if (from.isPrimitive() && this.to.isPrimitive()) {
            log.debug((Object)("checkcast from " + from + " to " + this.to));
            if (from.getCastOrder() > this.to.getCastOrder() || from.equals(AClass.CHAR_ACLASS) && this.to.equals(AClass.SHORT_ACLASS) || this.to.equals(AClass.CHAR_ACLASS) && from.equals(AClass.SHORT_ACLASS)) {
                this.insnHelper.cast(from.getType(), this.to.getType());
                return;
            }
        }
        log.debug((Object)("checkcast from " + from + " to " + this.to));
        this.insnHelper.checkCast(this.to.getType());
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        this.execute();
    }

    @Override
    public AClass getParamterizedType() {
        return this.to;
    }

    @Override
    public void asArgument() {
        this.block.removeExe(this);
    }
}

