/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.logical;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.logical.AbstractLogical;
import jw.asmsupport.operators.numerical.bitwise.BinaryBitwise;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BinaryLogical
extends AbstractLogical {
    private static Log log = LogFactory.getLog(BinaryBitwise.class);
    protected Parameterized factor1;
    protected Parameterized factor2;

    protected BinaryLogical(ProgramBlock block, Parameterized factor1, Parameterized factor2) {
        super(block);
        this.factor1 = factor1;
        this.factor2 = factor2;
    }

    @Override
    protected void verifyArgument() {
        AClass ftrCls1 = this.factor1.getParamterizedType();
        AClass ftrCls2 = this.factor2.getParamterizedType();
        if (!ftrCls1.equals(AClass.BOOLEAN_ACLASS) && !ftrCls1.equals(AClass.BOOLEAN_WRAP_ACLASS) || !ftrCls2.equals(AClass.BOOLEAN_ACLASS) && !ftrCls2.equals(AClass.BOOLEAN_WRAP_ACLASS)) {
            throw new ASMSupportException("the factor type must be boolean or Boolean for logical operator!");
        }
    }

    @Override
    protected void checkOutCrement() {
        if (this.factor1 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor1);
        }
        if (this.factor2 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor2);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.factor1.asArgument();
        this.factor2.asArgument();
    }

    @Override
    public void execute() {
        if (!this.byOtherUsed) {
            throw new ArithmeticException("the logical operator " + this.factor1.getParamterizedType() + " " + this.operator + " " + this.factor2.getParamterizedType() + " has not been used by other operator.");
        }
        super.execute();
    }

    @Override
    protected void factorToStack() {
        log.debug((Object)"factors to stack");
        this.factor1.loadToStack(this.block);
        this.insnHelper.unbox(this.factor1.getParamterizedType().getType());
        this.factor2.loadToStack(this.block);
        this.insnHelper.unbox(this.factor2.getParamterizedType().getType());
    }
}

