/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.logical;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.logical.AbstractLogical;
import jw.asmsupport.operators.numerical.bitwise.BinaryBitwise;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Label;

public abstract class UnaryLogical
extends AbstractLogical {
    private static Log log = LogFactory.getLog(BinaryBitwise.class);
    protected Parameterized factor;
    protected Label trueLbl;
    protected Label falseLbl;

    protected UnaryLogical(ProgramBlock block, Parameterized factor) {
        super(block);
        this.factor = factor;
        this.falseLbl = new Label();
        this.trueLbl = new Label();
    }

    @Override
    protected void verifyArgument() {
        AClass ftrCls = this.factor.getParamterizedType();
        if (!ftrCls.equals(AClass.BOOLEAN_ACLASS) || ftrCls.equals(AClass.BOOLEAN_WRAP_ACLASS)) {
            throw new ASMSupportException("the factor type must be boolean or Boolean for logical operator!");
        }
    }

    @Override
    protected void checkOutCrement() {
        if (this.factor instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.factor.asArgument();
    }

    @Override
    public void execute() {
        if (!this.byOtherUsed) {
            throw new ASMSupportException("the logical operator " + this.operator + " " + this.factor.getParamterizedType() + " has not been used by other operator.");
        }
        super.execute();
    }

    @Override
    protected void factorToStack() {
        log.debug((Object)"factors to stack");
        this.factor.loadToStack(this.block);
        this.insnHelper.unbox(this.factor.getParamterizedType().getType());
    }
}

