/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.method;

import java.lang.reflect.Modifier;
import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.definition.variable.IVariable;
import jw.asmsupport.entity.VariableEntity;
import jw.asmsupport.operators.method.MethodInvoker;
import jw.asmsupport.operators.method.StaticMethodInvoker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Type;

public class CommonMethodInvoker
extends MethodInvoker {
    private static Log log = LogFactory.getLog(CommonMethodInvoker.class);
    private Parameterized callObjReference;

    protected CommonMethodInvoker(ProgramBlock block, Parameterized objRef, String name, Parameterized[] arguments) {
        super(block, objRef.getParamterizedType(), name, arguments);
        this.callObjReference = objRef;
        if (this.callObjReference.getParamterizedType().isPrimitive()) {
            throw new IllegalArgumentException("cannot invoke method at primitive type \"" + this.callObjReference.getParamterizedType() + "\" : must be a non-primitive variable");
        }
        this.setSaveReference(false);
        if (this.callObjReference instanceof MethodInvoker) {
            ((MethodInvoker)this.callObjReference).setSaveReference(true);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.callObjReference.asArgument();
        super.checkAsArgument();
    }

    @Override
    public void lastPrepareProcess() {
        if (Modifier.isStatic(this.getModifiers())) {
            StaticMethodInvoker mi = new StaticMethodInvoker(this.block, this.getActuallyOwner(), this.name, this.arguments);
            this.block.removeExe(mi);
            this.block.replaceExe(this, mi);
        }
    }

    @Override
    protected void executing() {
        if (!Modifier.isStatic(this.getModifiers())) {
            log.info((Object)"put reference to stack");
            this.callObjReference.loadToStack(this.block);
            this.argumentsToStack();
            if (this.callObjReference.getParamterizedType().isInterface()) {
                log.info((Object)("invoke interface method : " + this.name));
                this.insnHelper.invokeInterface(this.callObjReference.getParamterizedType().getType(), this.name, this.getReturnType(), this.mtdEntity.getArgTypes());
            } else {
                log.info((Object)("invoke class method : " + this.name));
                if (this.callObjReference instanceof IVariable) {
                    VariableEntity ve = ((IVariable)this.callObjReference).getVariableEntity();
                    if (ve.getName().equals("super")) {
                        this.insnHelper.invokeSuperMethod(this.callObjReference.getParamterizedType().getType(), this.name, this.getReturnType(), this.mtdEntity.getArgTypes());
                    } else {
                        this.insnHelper.invokeVirtual(this.callObjReference.getParamterizedType().getType(), this.name, this.getReturnType(), this.mtdEntity.getArgTypes());
                    }
                } else {
                    this.insnHelper.invokeVirtual(this.callObjReference.getParamterizedType().getType(), this.name, this.getReturnType(), this.mtdEntity.getArgTypes());
                }
            }
            if (!this.isSaveReference() && !this.getReturnType().equals((Object)Type.VOID_TYPE)) {
                this.insnHelper.pop();
            }
        }
    }

    public String toString() {
        return this.callObjReference + "." + this.mtdEntity;
    }
}

