/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.method;

import java.util.ArrayList;
import jw.asmsupport.Parameterized;
import jw.asmsupport.asm.InstructionHelper;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.definition.method.Method;
import jw.asmsupport.definition.variable.IVariable;
import jw.asmsupport.entity.MethodEntity;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.exception.NoSuchMethod;
import jw.asmsupport.operators.AbstractOperator;
import jw.asmsupport.operators.array.ArrayValue;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import jw.asmsupport.utils.AClassUtils;
import jw.asmsupport.utils.ModifierUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Type;

public abstract class MethodInvoker
extends AbstractOperator
implements Parameterized {
    protected static String METHOD_NAME_INIT = "<init>";
    private static Log log = LogFactory.getLog(MethodInvoker.class);
    protected String name;
    protected Parameterized[] arguments;
    protected AClass methodOwner;
    private boolean saveReturn;
    protected MethodEntity mtdEntity;

    protected MethodInvoker(ProgramBlock block, AClass owner, String name, Parameterized[] arguments) {
        super(block);
        this.methodOwner = owner;
        this.name = name;
        this.arguments = arguments;
    }

    protected void argumentsToStack() {
        for (int i = 0; i < this.arguments.length; ++i) {
            Parameterized argu = this.arguments[i];
            log.debug((Object)"push argument to stack");
            if (argu instanceof IVariable) {
                ((IVariable)argu).availableFor(this);
            }
            argu.loadToStack(this.block);
            this.cast(argu.getParamterizedType(), this.mtdEntity.getArgClasses()[i]);
        }
    }

    private void cast(AClass from, AClass to) {
        if (from.isPrimitive() && to.isPrimitive()) {
            this.insnHelper.cast(from.getType(), to.getType());
        } else if (from.isPrimitive()) {
            this.insnHelper.box(from.getType());
        } else if (AClassUtils.isPrimitiveWrapAClass(from) && to.isPrimitive()) {
            Type primType = InstructionHelper.getUnBoxedType(from.getType());
            this.insnHelper.unbox(from.getType());
            this.insnHelper.cast(primType, to.getType());
        }
    }

    @Override
    protected void beforeInitProperties() {
        AClass[] foundMethodArgTypes;
        AClass[] argumentClasses = new AClass[this.arguments.length];
        ArrayList<AClass> argumentClassList = new ArrayList<AClass>();
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentClassList.add(this.arguments[i].getParamterizedType());
        }
        argumentClassList.toArray(argumentClasses);
        Method currentMethod = this.block.getMethod();
        if (currentMethod.getMode() == 1 && this.name.endsWith("@ByProxy")) {
            this.mtdEntity = (MethodEntity)currentMethod.getMethodEntity().clone();
            this.mtdEntity.setName(this.name);
        } else if (this.name.equals(METHOD_NAME_INIT)) {
            this.mtdEntity = this.methodOwner.availableConstructor(this.block.getMethodOwner(), argumentClasses);
            if (this.mtdEntity == null) {
                throw new NoSuchMethod(this.methodOwner, this.name, argumentClasses);
            }
        } else {
            this.mtdEntity = this.methodOwner.availableMethod(this.block.getMethodOwner(), this.name, argumentClasses);
            if (this.mtdEntity == null) {
                throw new NoSuchMethod(this.methodOwner, this.name, argumentClasses);
            }
        }
        if (ModifierUtils.isVarargs(this.mtdEntity.getModifier()) && (ArrayUtils.getLength((Object)(foundMethodArgTypes = this.mtdEntity.getArgClasses())) != ArrayUtils.getLength((Object)this.arguments) || !this.arguments[ArrayUtils.getLength((Object)this.arguments) - 1].getParamterizedType().isArray())) {
            int fixedArgsLen = this.mtdEntity.getArgClasses().length - 1;
            Object[] fixedArgs = new Parameterized[fixedArgsLen];
            System.arraycopy(this.arguments, 0, fixedArgs, 0, fixedArgsLen);
            ArrayClass arrayClass = (ArrayClass)this.mtdEntity.getArgClasses()[this.mtdEntity.getArgClasses().length - 1];
            ArrayValue variableVarifyArauments = this.block.newArrayWithValue(arrayClass, (Parameterized[])ArrayUtils.subarray((Object[])this.arguments, (int)fixedArgsLen, (int)this.arguments.length));
            variableVarifyArauments.asArgument();
            this.arguments = (Parameterized[])ArrayUtils.add((Object[])fixedArgs, (Object)variableVarifyArauments);
        }
        for (AClass exception : this.mtdEntity.getExceptions()) {
            this.block.addException(exception);
        }
    }

    @Override
    protected void checkOutCrement() {
        for (Parameterized argu : this.arguments) {
            if (!(argu instanceof AbstractCrement)) continue;
            this.allCrement.add((AbstractCrement)argu);
        }
    }

    @Override
    protected void checkAsArgument() {
        for (Parameterized argu : this.arguments) {
            argu.asArgument();
        }
    }

    public boolean isSaveReference() {
        return this.saveReturn;
    }

    @Override
    public void asArgument() {
        this.block.removeExe(this);
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        if (this.getReturnType().equals((Object)Type.VOID_TYPE)) {
            throw new ASMSupportException("cannot push the void return type to stack!");
        }
        boolean saveRef = this.isSaveReference();
        this.setSaveReference(true);
        this.execute();
        this.setSaveReference(saveRef);
    }

    public void setSaveReference(boolean saveReturn) {
        this.saveReturn = saveReturn;
    }

    public Type getReturnType() {
        return this.getReturnClass() != null ? this.getReturnClass().getType() : Type.VOID_TYPE;
    }

    public final AClass getReturnClass() {
        if (this.name.equals(METHOD_NAME_INIT)) {
            return this.methodOwner;
        }
        if (this.mtdEntity != null) {
            return this.mtdEntity.getReturnClass();
        }
        return AClass.VOID_ACLASS;
    }

    protected AClass getActuallyOwner() {
        return this.mtdEntity.getActuallyOwner();
    }

    public int getModifiers() {
        return this.mtdEntity.getModifier();
    }

    @Override
    public AClass getParamterizedType() {
        return this.getReturnClass();
    }
}

