/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.method;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.operators.method.MethodInvoker;
import jw.asmsupport.utils.ModifierUtils;
import org.apache.commons.lang.IllegalClassException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Type;

public class StaticMethodInvoker
extends MethodInvoker {
    private static Log log = LogFactory.getLog(StaticMethodInvoker.class);

    protected StaticMethodInvoker(ProgramBlock block, AClass owner, String name, Parameterized[] arguments) {
        super(block, owner, name, arguments);
        if (owner.isPrimitive()) {
            throw new IllegalClassException("Cannot call static method from primitive");
        }
        this.setSaveReference(false);
    }

    @Override
    protected void beforeInitProperties() {
        super.beforeInitProperties();
        if (!ModifierUtils.isStatic(this.mtdEntity.getModifier())) {
            throw new IllegalArgumentException("\"" + this.mtdEntity.toString() + "\" is not a static method ");
        }
    }

    @Override
    public void executing() {
        this.argumentsToStack();
        log.debug((Object)("invoke static method : " + this.name));
        this.insnHelper.invokeStatic(this.methodOwner.getType(), this.name, this.getReturnType(), this.mtdEntity.getArgTypes());
        if (!this.isSaveReference() && !this.getReturnType().equals((Object)Type.VOID_TYPE)) {
            this.insnHelper.pop();
        }
    }

    public String toString() {
        return this.methodOwner + "." + this.mtdEntity;
    }
}

