/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.numerical.arithmetic;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.operators.numerical.AbstractNumerical;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import jw.asmsupport.utils.AClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractArithmetic
extends AbstractNumerical
implements Parameterized {
    private static Log log = LogFactory.getLog(AbstractArithmetic.class);
    protected Parameterized factor1;
    protected Parameterized factor2;
    private boolean byOtherUsed;

    protected AbstractArithmetic(ProgramBlock block, Parameterized factor1, Parameterized factor2) {
        super(block);
        this.factor1 = factor1;
        this.factor2 = factor2;
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        this.execute();
    }

    @Override
    protected void verifyArgument() {
        AClass f1cls = this.factor1.getParamterizedType();
        AClass f2cls = this.factor2.getParamterizedType();
        if (!AClassUtils.arithmetical(f1cls) || !AClassUtils.arithmetical(f2cls)) {
            throw new ArithmeticException("cannot execute arithmetic operator whit " + f1cls + " and " + f2cls);
        }
    }

    @Override
    protected void checkOutCrement() {
        if (this.factor1 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor1);
        }
        if (this.factor2 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor2);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.factor1.asArgument();
        this.factor2.asArgument();
    }

    @Override
    protected void afterInitProperties() {
        AClass f1cls = this.factor1.getParamterizedType();
        AClass f2cls = this.factor2.getParamterizedType();
        f1cls = AClassUtils.getPrimitiveAClass(f1cls);
        f2cls = AClassUtils.getPrimitiveAClass(f2cls);
        this.resultClass = f1cls.getCastOrder() > f2cls.getCastOrder() ? f1cls : f2cls;
    }

    @Override
    public void execute() {
        if (!this.byOtherUsed) {
            throw new ArithmeticException("the arithmetic operator " + this.factor1.getParamterizedType() + " " + this.operator + " " + this.factor2.getParamterizedType() + " has not been used by other operator.");
        }
        super.execute();
    }

    @Override
    protected void factorToStack() {
        AClass ftrCls1 = this.factor1.getParamterizedType();
        AClass ftrCls2 = this.factor2.getParamterizedType();
        log.debug((Object)"push the first arithmetic factor to stack");
        this.factor1.loadToStack(this.block);
        if (!ftrCls1.isPrimitive()) {
            log.debug((Object)("unbox " + ftrCls1));
            this.insnHelper.unbox(ftrCls1.getType());
        }
        if (!ftrCls1.equals(this.resultClass) && this.resultClass.getCastOrder() > AClass.INT_ACLASS.getCastOrder()) {
            log.debug((Object)("cast arithmetic factor from " + ftrCls1 + " to " + this.resultClass));
            this.insnHelper.cast(ftrCls1.getType(), this.resultClass.getType());
        }
        log.debug((Object)"push the second arithmetic factor to stack");
        this.factor2.loadToStack(this.block);
        if (!ftrCls2.isPrimitive()) {
            log.debug((Object)("unbox " + ftrCls2));
            this.insnHelper.unbox(ftrCls2.getType());
        }
        if (!ftrCls2.equals(this.resultClass) && this.resultClass.getCastOrder() > AClass.INT_ACLASS.getCastOrder()) {
            log.debug((Object)("cast arithmetic factor from " + ftrCls2 + " to " + this.resultClass));
            this.insnHelper.cast(ftrCls2.getType(), this.resultClass.getType());
        }
    }

    @Override
    public void asArgument() {
        this.block.removeExe(this);
        this.byOtherUsed = true;
    }
}

